/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.BuildMode;
import ebuild.core.impl.Version;
import java.io.File;

public abstract class Project {
    protected final ElementC elementC;

    protected Project(ElementC cElement) {
        this.elementC = cElement;
    }

    public Element getPart() {
        return this.elementC.element;
    }

    public ConfMap getConfiguration() {
        return this.elementC.getConfiguration();
    }

    public ConfMap getConfigurationSelected() {
        return this.elementC.getConfigurationSelected();
    }

    public abstract BuildMode mode();

    public ElementC getCPart() {
        return this.elementC;
    }

    public String getName() {
        return this.getPart().getName();
    }

    public Version getVersion() {
        return this.getPart().getVersion();
    }

    public File getProjectFile(String path) {
        return new File(this.getPart().getProjectDirectory(), path);
    }

    public boolean isBuilt() {
        return this.elementC.getReleaseFile().exists();
    }

    public String toString() {
        return String.valueOf(this.mode().code) + " " + this.getPart().key + " " + this.getConfiguration();
    }
}

