/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.log.ILogger;
import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.base.BuildPluginType;
import ebuild.base.EBuildException;
import ebuild.base.EBuildLogger;
import ebuild.base.PluginUtil;
import ebuild.base.Task;
import ebuild.compat.AbstractCompatability;
import ebuild.compat_0_8.Compatability;
import ebuild.core.BuildPlanRunner;
import ebuild.core.EBuild;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.ModuleC;
import ebuild.core.impl.BuildTask;
import ebuild.core.impl.DependencyType;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Version;
import ebuild.repo.http.HttpRepositoryProvider;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.JSONUtil;
import ebuild.version.EBuildVersion;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemPlugins {
    private static Map<String, Version> name2version = CollectionUtil.newMap("repo.svn", Version.newTag("0.8-5"), "repo.maven", Version.newTag("0.8"), "repo.ivy", Version.newTag("0.8"), "compat.0_7", Version.newRevision("0.8", "499"));
    static final String PLUGIN_SUBDIR = "system/plugins/";
    private final EBuild ebuild0;
    private final EBuild ebuild;
    private final ILogger logger;
    private static Map<String, String> type2plugin = CollectionUtil.newMap("svn", "repo.svn", "maven", "repo.maven", "ivy", "repo.ivy", "http", "repo.http");

    private static Version getVersion(EBuild ebuild0, String name) {
        String versionStr = ebuild0.getSettingProp("version-" + name);
        return Version.fromString(versionStr, name2version.get(name));
    }

    SystemPlugins(EBuild ebuild) {
        EBuild.Options options = (EBuild.Options)ebuild.options.clone();
        options.noSkipping = false;
        options.verbosity = options.verbosity.isVeryVerbose() ? EBuild.Verbosity.two : EBuild.Verbosity.normal;
        options.workspaces = null;
        File homeDev = this.getHomeOfEbuildClasses();
        if (homeDev != null) {
            options.home = homeDev;
        }
        this.ebuild0 = ebuild;
        this.ebuild = new EBuild(ebuild.apiClassLoader, options, (EBuildLogger)ebuild.logger.newSubLogger("Installing System Plugin"), false, this);
        this.logger = ebuild.logger;
    }

    private File getHomeOfEbuildClasses() {
        URL url = SystemPlugins.class.getResource(".");
        if (url == null || !"file".equals(url.getProtocol())) {
            return null;
        }
        return FileUtil.canonicalFile(new File("../_ebuild"));
    }

    private Module installModule(String name, Version v) throws EBuildException {
        Module module;
        KeyE key = new KeyE(ElementType.module, "release", "ebuild", name, v);
        Task.start("Install module", key);
        this.ebuild.report.startResolve(this.ebuild.context, "Install " + key.fullnameAndVersion());
        try {
            Module module2;
            if (key.version.isWorking()) {
                if (this.ebuild.options.home == null) {
                    throw EBuildException.newInternalError("Cannot use working version of plugin: " + key);
                }
                module2 = (Module)this.ebuild.context.resolveWorkspaceElement(key.fullname());
                if (module2 == null) {
                    throw EBuildException.newConfProblem("No ebuild project: " + key.fullname());
                }
            } else {
                module2 = (Module)this.ebuild.context.resolveElement(DependencyType.TOP, "public", key);
            }
            Install install = new Install(this.ebuild, module2);
            install.go();
            module = module2;
            this.ebuild.report.endResolve();
        }
        catch (Throwable throwable) {
            try {
                this.ebuild.report.endResolve();
                Task.end(key);
                throw throwable;
            }
            catch (Exception e) {
                throw EBuildException.newInternalError("Failed to install repository provider: " + name, e);
            }
        }
        Task.end(key);
        return module;
    }

    private List<String> addInParentDir(List<String> classpath) {
        ArrayList<String> r = new ArrayList<String>(classpath.size());
        for (String s : classpath) {
            if (s.contains("ebuild-api") && !s.contains("remap")) continue;
            s = this.ebuild.HOME.getPossiblyRelativeFile(new File(s)).getAbsolutePath();
            r.add(s);
        }
        return r;
    }

    private File getPluginPathFile(String name) {
        String pathPath = PLUGIN_SUBDIR + name;
        return this.ebuild.HOME.getFile(pathPath);
    }

    private PluginPath expectPluginPath(File pathFile) throws EBuildException {
        if (!pathFile.exists()) {
            throw EBuildException.newInternalError("Expected " + this.ebuild.getPathInWorkspace(pathFile));
        }
        try {
            return PluginPath.read(pathFile);
        }
        catch (Exception e) {
            throw EBuildException.newInternalError("Unable to read system plugin path file: " + this.ebuild.getPathInWorkspace(pathFile), e);
        }
    }

    private PluginPath getPluginPath(File pathFile) {
        if (!pathFile.exists()) {
            return null;
        }
        try {
            return PluginPath.read(pathFile);
        }
        catch (Exception e) {
            this.logger.warn("Unable to read system plugin path file: " + this.ebuild.getPathInWorkspace(pathFile), e);
            return null;
        }
    }

    private Object loadPlugin(BuildPluginType type, File pathFile, PluginPath path) throws EBuildException {
        String class_ = path.class_;
        List<String> classpath = this.addInParentDir(path.classpath);
        ClassLoader cl = PluginUtil.createPluginClassLoader(type, super.getClass().getClassLoader(), classpath);
        if (this.ebuild.isDEBUG()) {
            if (type == BuildPluginType.COMPAT) {
                this.logger.log("path for '" + pathFile.getName() + "' api part: ");
                this.logger.log(PluginUtil.displayClassloader(this.ebuild, cl.getParent()));
            }
            this.logger.log("path for '" + pathFile.getName() + "': ");
            this.logger.log(PluginUtil.displayClassloader(this.ebuild, cl));
        }
        return PluginUtil.instantiate(this.ebuild, cl, class_);
    }

    private Object loadPlugin(BuildPluginType type, String name, Version v) throws EBuildException {
        try {
            File pathFile = this.getPluginPathFile(name);
            PluginPath path = this.expectPluginPath(pathFile);
            String version = path.version;
            if (version != null && !v.toString().equals(version)) {
                throw EBuildException.newInternalError("Invalid version: " + version);
            }
            return this.loadPlugin(type, pathFile, path);
        }
        catch (Exception e) {
            throw EBuildException.newInternalError("Unable to load system plugin", e);
        }
    }

    private Object loadPluginAttempt(BuildPluginType type, String name, Version v) {
        PluginPath path;
        File pathFile;
        block4: {
            pathFile = this.getPluginPathFile(name);
            path = this.getPluginPath(pathFile);
            if (path == null) {
                return null;
            }
            try {
                String version = path.version;
                if (version == null || v.toString().equals(version)) break block4;
                return null;
            }
            catch (Exception e) {
                this.logger.warn("Problem loading previously installed plugin: " + name, e);
                return null;
            }
        }
        return this.loadPlugin(type, pathFile, path);
    }

    private Object usePlugin(BuildPluginType type, String name) throws EBuildException {
        this.logger.log("*using '" + name + "'");
        Version v = SystemPlugins.getVersion(this.ebuild, name);
        if (v == null) {
            throw EBuildException.newInternalError("No such system module: " + name, null);
        }
        Object plugin = this.loadPluginAttempt(type, name, v);
        if (plugin == null) {
            this.installModule(name, v);
            Task.start("load plugin", name);
            try {
                plugin = this.loadPlugin(type, name, v);
            }
            finally {
                Task.end(name);
            }
        }
        return plugin;
    }

    public AbstractCompatability useCompatability(EBuildVersion v) throws EBuildException {
        if (EBuildVersion._0_8 == v) {
            return new Compatability();
        }
        String name = "compat." + v.name().substring(1);
        return (AbstractCompatability)this.usePlugin(BuildPluginType.COMPAT, name);
    }

    public AbstractRepositoryProvider useRepoProvider(String repoType) throws EBuildException {
        if ("http".equals(repoType)) {
            HttpRepositoryProvider r = new HttpRepositoryProvider();
            r.initLogger(this.logger.newSubLogger("repo.http"));
            return r;
        }
        String name = type2plugin.get(repoType);
        if (name == null) {
            throw EBuildException.newInternalError("Unknown repository type: " + repoType);
        }
        AbstractRepositoryProvider r = (AbstractRepositoryProvider)this.usePlugin(BuildPluginType.REPO, name);
        r.initLogger(this.logger.newSubLogger(name));
        r.initCredentials(this.ebuild0.getCredentialsFile(String.valueOf(repoType) + ".logins"));
        return r;
    }

    public void registerSystemPlugin(ModuleC moduleC, Collection<String> classpath) {
        Module module = (Module)moduleC.element;
        KeyE key = module.key;
        Version v = SystemPlugins.getVersion(module.ebuild, key.name);
        if (v == null) {
            return;
        }
        PluginPath path = new PluginPath(key.version.toString(), module.buildPlugin.getPluginClass(), new ArrayList<String>(classpath));
        String name = key.org.equals("ebuild") ? key.name : key.fullname();
        try {
            File classpathFile = this.getPluginPathFile(name);
            FileUtil.mkdirOrFail(classpathFile.getParentFile());
            path.write(classpathFile);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public List<PluginPath> listInstalledPlugins() {
        ArrayList<PluginPath> r = new ArrayList<PluginPath>();
        File subdir = this.ebuild.HOME.getFile(PLUGIN_SUBDIR);
        if (subdir.isDirectory()) {
            File[] fileArray = subdir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File pathFile = fileArray[n2];
                PluginPath path = this.getPluginPath(pathFile);
                r.add(path);
                ++n2;
            }
        }
        return r;
    }

    public static class Install
    extends BuildPlanRunner {
        final EBuild ebuild;
        final Module module;

        public Install(EBuild ebuild, Module module) throws Exception {
            this.ebuild = ebuild;
            this.module = module;
        }

        protected EBuild getEBuild() {
            return this.ebuild;
        }

        public void go() throws Exception {
            ModuleBuildPlan bp = new ModuleBuildPlan(this.getEBuild(), (ModuleC)this.module.getDefault(), ModuleC.NOAPI);
            this.go(bp, BuildTask.build_release);
        }

        public String getKey() {
            return "install " + this.module.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PluginPath {
        public final String version;
        public final String class_;
        public final List<String> classpath;

        PluginPath(String version, String class_, List<String> classpath) {
            this.version = version;
            this.class_ = class_;
            this.classpath = classpath;
        }

        public void write(File file) throws IOException {
            HashMap<String, Object> m = new HashMap<String, Object>(3);
            m.put("version", this.version);
            m.put("class", this.class_);
            m.put("classpath", this.classpath);
            JSONUtil.writeObject(file, m);
        }

        public static PluginPath read(File file) throws Exception {
            Map m = JSONUtil.readMap(new FileReader(file));
            String version = (String)m.get("version");
            String class_ = (String)m.get("class");
            List classpath = (List)m.get("classpath");
            if (version == null) {
                throw new NullPointerException();
            }
            if (class_ == null) {
                throw new NullPointerException();
            }
            if (classpath == null) {
                throw new NullPointerException();
            }
            return new PluginPath(version, class_, classpath);
        }
    }
}

