/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.base.EBuildException;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.EBuild;
import ebuild.core.ElementC;
import ebuild.core.impl.BuildTaskSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopBuildPlan
extends BuildPlan {
    private final Collection<ElementC> elementsC;
    private final List<BuildPlan> subPlans;

    public TopBuildPlan(EBuild ebuild, Collection<ElementC> elementsC) {
        super(ebuild, "release");
        this.elementsC = elementsC;
        this.subPlans = new ArrayList<BuildPlan>(elementsC.size());
    }

    @Override
    protected void resolveBuilders(BuildTaskSet tasks) throws EBuildException {
    }

    @Override
    protected void resolveAndConfigureDependencies(BuildTaskSet tasks) throws EBuildException {
        for (ElementC ce : this.elementsC) {
            BuildPlan subPlan = this.ebuild.getBuildPlan(ce);
            this.subPlans.add(subPlan);
            this.report.configure(ce.key.ekey, ce.getConfigurationSelected());
        }
        for (BuildPlan bp : this.subPlans) {
            bp.resolveAndConfigure(tasks);
        }
    }

    @Override
    protected void buildActionListForPlan(ActionQueue queue, BuildTaskSet tasks) throws Exception {
        for (BuildPlan subPlan : this.subPlans) {
            subPlan.buildActionList(queue, tasks);
        }
    }
}

