/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;

public class DependencyType
implements Comparable {
    private static int counter = 0;
    public final String name;
    final int order;
    public static final DependencyType MAIN = new DependencyType("MAIN");
    public static final DependencyType TEST = new DependencyType("TEST");
    public static final DependencyType POKE = new DependencyType("POKE");
    public static final DependencyType BUILDER = new DependencyType("BUILDER");
    public static final DependencyType ASSEMBLER = new DependencyType("ASSEMBLER");
    public static final DependencyType PRODUCT = new DependencyType("PRODUCT");
    public static final DependencyType CONF = new DependencyType("CONF");
    public static final DependencyType TOP = new DependencyType("TOP");

    public static DependencyType getForScope(Scope scope) {
        if (Scope.MAIN == scope) {
            return MAIN;
        }
        if (Scope.TEST == scope) {
            return TEST;
        }
        if (Scope.POKE == scope) {
            return POKE;
        }
        throw new Error();
    }

    public static DependencyType getForBuilder(ElementType type) {
        if (ElementType.module == type) {
            return BUILDER;
        }
        if (ElementType.product == type) {
            return ASSEMBLER;
        }
        throw new Error();
    }

    DependencyType(String name, int order) {
        this.name = name;
        this.order = order;
    }

    DependencyType(String name) {
        this(name, counter++);
    }

    public int compareTo(Object o) {
        return this.order - ((DependencyType)o).order;
    }

    public static class Role
    extends DependencyType {
        public Role(String role) {
            super("Role: " + role);
        }
    }
}

