/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.api.plugin.IPropertyMap;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.core.conf.ConfExpr;
import ebuild.core.conf.ConfExprException;
import ebuild.core.conf.ConfMap;
import ebuild.core.conf.ConfMapping;
import ebuild.core.conf.Parser;
import ebuild.core.impl.Version;
import ebuild.core.util.NameTemplate;
import ebuild.util.FileUtil;
import ebuild.xml.CmnXml;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBuildUtil {
    public static final String FILENAME_CMP_DECL = MetaType.PRODUCT.name;
    public static final String FILENAME_CMP_BUILD = MetaType.PRODUCT_ASSEMBLY.name;
    public static final String FILENAME_MOD_DECL = MetaType.MODULE.name;
    public static final String FILENAME_MOD_BUILD = MetaType.MODULE_BUILD.name;

    public static Version asVersion(CmnXml.Version v) {
        return EBuildUtil.asVersion(v, null);
    }

    public static Version asVersion(CmnXml.Version v, Version default_) {
        String tag = v.getTag();
        if (tag != null) {
            return Version.newTag(tag);
        }
        if (v.getBranch() != null || v.getRevision() != null) {
            Version r = Version.newRevision(v.getBranch(), v.getRevision());
            return r.withDefault(default_);
        }
        return default_;
    }

    public static ElementType getElementType(File directory) throws EBuildException {
        File metaDir = new File(directory, "meta");
        if (new File(metaDir, FILENAME_CMP_DECL).isFile()) {
            return ElementType.product;
        }
        if (new File(metaDir, "component.xml").isFile()) {
            return ElementType.product;
        }
        if (new File(metaDir, FILENAME_MOD_DECL).isFile()) {
            return ElementType.module;
        }
        return null;
    }

    public static ElementType expectElementType(File directory) throws EBuildException {
        ElementType r = EBuildUtil.getElementType(directory);
        if (r == null) {
            throw EBuildException.newConfProblem("Not an ebuild directory: " + FileUtil.canonicalFile(directory));
        }
        return r;
    }

    public static boolean includesScope(Scope a, Scope b) {
        if (a == null) {
            return false;
        }
        return a.includes(b);
    }

    public static Scope combineScopes(Scope a, Scope b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a == b) {
            return a;
        }
        if (a.includes(b)) {
            return a;
        }
        if (b.includes(a)) {
            return b;
        }
        throw new Error("Cannot combine scopes " + a + " and " + b);
    }

    public static Scope getScope(String name, Scope default_) {
        Scope r = Scope.get((String)name);
        if (r == null) {
            return default_;
        }
        return r;
    }

    public static boolean evaluateExpr(String expr, ConfMap confs) throws EBuildException {
        ConfExpr r = EBuildUtil.parseConfExpr(expr);
        return r.evaluate(confs);
    }

    public static ConfMap evaluateMapping(String expr, ConfMap confs) throws EBuildException {
        ConfMapping r = EBuildUtil.parseMapping(expr);
        return r.evaluate(confs);
    }

    public static ConfMapping newMapping(ConfMap set) {
        try {
            return EBuildUtil.parseMapping("->" + set);
        }
        catch (EBuildException e) {
            throw new Error(e);
        }
    }

    public static ConfMapping parseMapping(String mapping) throws EBuildException {
        return EBuildUtil.parseMapping(mapping, ConfMapping.EMPTY);
    }

    public static ConfMapping parseMapping(String mapping, ConfMapping default_) throws EBuildException {
        if (mapping == null) {
            return default_;
        }
        try {
            return Parser.parseConfMapping(mapping);
        }
        catch (ConfExprException e) {
            throw EBuildException.newConfProblem("Invalid mapping '" + mapping + "' - " + e.getMessage());
        }
    }

    public static ConfExpr parseConfExpr(String expr) throws EBuildException {
        try {
            return Parser.parseConfExpr(expr);
        }
        catch (ConfExprException e) {
            throw EBuildException.newConfProblem("Invalid expr '" + expr + "' - " + e.getMessage());
        }
    }

    public static ConfMap parseConfMap(String confSet) throws EBuildException {
        try {
            return Parser.parseConfMap(confSet);
        }
        catch (ConfExprException e) {
            throw EBuildException.newConfProblem("Invalid confs '" + confSet + "' - " + e.getMessage());
        }
    }

    public static IPropertyMap configureProperties(IPropertyMap r, ConfMap configuration, List<CmnXml.Property> propList) throws EBuildException {
        for (CmnXml.Property p : propList) {
            if (!EBuildUtil.evaluateExpr(p.conf, configuration)) continue;
            r.put(p.key, p.getValue());
        }
        return r;
    }

    public static NameTemplate.Model newNameTemplateModel(final Version version, final ConfMap confs) {
        return new NameTemplate.Model(){

            public String getValue(String varname) {
                if ("version".equals(varname)) {
                    return "" + version;
                }
                if (confs != null && "confs".equals(varname)) {
                    return confs.asFileTrailingPart();
                }
                return null;
            }
        };
    }
}

