/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.api.IInput;
import ebuild.api.IInputMap;
import ebuild.api.plugin.BuildPluginProblem;
import ebuild.util.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputMap
implements IInputMap {
    private final Map<String, IInput> inputs = new HashMap<String, IInput>(1);

    public IInput getInput(String name) {
        return this.inputs.get(name);
    }

    public IInput expectInput(String name) throws BuildPluginProblem {
        IInput r = this.getInput(name);
        if (r == null) {
            throw new BuildPluginProblem("Expected named input '" + name + "'");
        }
        return r;
    }

    public IInput expectLoneInput() throws BuildPluginProblem {
        if (this.inputs.size() > 1) {
            throw new BuildPluginProblem("Expected single input, got several inputs: " + StringUtil.join(",", this.inputs.keySet()));
        }
        return this.inputs.values().iterator().next();
    }

    public Collection<String> inputKeys() {
        return this.inputs.keySet();
    }

    public void put(String key, IInput value) {
        this.inputs.put(key, value);
    }
}

