/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.util.JSONUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentMap {
    final File file;
    protected Map<String, String> map;

    public PersistentMap(File file) {
        this.file = file;
    }

    public Map<String, String> getMap() {
        if (this.map == null) {
            this.map = this.read();
        }
        return this.map;
    }

    public String get(String lookup) {
        return this.getMap().get(lookup);
    }

    public void putAndUpdate(String lookup, String value) {
        this.getMap().put(lookup, value);
        this.update();
    }

    public void update() {
        if (this.map != null) {
            JSONUtil.writeObjectOrError(this.file, this.map);
        }
    }

    private Map<String, String> read() {
        if (!this.file.exists()) {
            return new HashMap<String, String>();
        }
        return (Map)JSONUtil.readObjectOrError(this.file);
    }

    public String getFileName() {
        return this.file.getName();
    }
}

