/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.core.impl.KeyE;
import ebuild.core.impl.PersistentMap;
import ebuild.util.JSONUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class UpstreamRevisions
extends PersistentMap {
    private Map<String, String> locals = new HashMap<String, String>();

    public UpstreamRevisions(File file) {
        super(file);
    }

    public String lookup(KeyE dkey) {
        String lookup = String.valueOf(dkey.org) + "-" + dkey.name;
        String branch = dkey.version.getBranch();
        if (branch != null) {
            lookup = String.valueOf(lookup) + "-" + branch;
        }
        return lookup;
    }

    public String get(KeyE dkey) {
        String lookup = this.lookup(dkey);
        return this.get(lookup);
    }

    public void putLocal(KeyE key) {
        this.locals.put(this.lookup(key), key.version.getRevision());
    }

    public void generateWithLocals(File dir) {
        File genfile = new File(dir, this.file.getName());
        HashMap<String, String> m = new HashMap<String, String>();
        if (this.locals.size() > 0) {
            m.putAll(this.locals);
            if (this.map != null) {
                m.putAll(this.map);
            }
            JSONUtil.writeObjectOrError(genfile, m);
        }
    }
}

