/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.util;

import ebuild.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PObject {
    private PObject[] prototypes = new PObject[0];
    private Slot[] slots = new Slot[0];

    protected boolean cache() {
        return true;
    }

    public void addPrototypes(PObject ... ps) {
        PObject[] old = this.prototypes;
        this.prototypes = new PObject[this.prototypes.length + ps.length];
        System.arraycopy(old, 0, this.prototypes, 0, old.length);
        System.arraycopy(ps, 0, this.prototypes, old.length, ps.length);
    }

    private Slot getSlot(SlotKey key) {
        Slot[] slotArray = this.slots;
        int n = this.slots.length;
        int n2 = 0;
        while (n2 < n) {
            Slot s = slotArray[n2];
            if (key == s.key) {
                return s;
            }
            ++n2;
        }
        return null;
    }

    private Slot useSlot(SlotKey key) {
        Slot s = this.getSlot(key);
        if (s == null) {
            s = new Slot(key);
            Slot[] old = this.slots;
            this.slots = new Slot[this.slots.length + 1];
            System.arraycopy(old, 0, this.slots, 0, old.length);
            this.slots[old.length] = s;
        }
        return s;
    }

    public <K, V> void put(SlotKey<K, V> slotKey, K key, V value) {
        this.useSlot(slotKey).values.put(key, value);
    }

    public <K, V> V get(SlotKey<K, V> slotKey, K key) {
        V r = this.getOur(slotKey, key);
        if (r != null) {
            return r;
        }
        return this.getPrevious(slotKey, key);
    }

    public <K, V> V getOur(SlotKey<K, V> slotKey, K key) {
        Slot slot = this.getSlot(slotKey);
        if (slot == null) {
            return null;
        }
        return slot.values.get(key);
    }

    public <K, V> V getPrevious(SlotKey<K, V> slotKey, K key) {
        PObject[] pObjectArray = this.prototypes;
        int n = this.prototypes.length;
        int n2 = 0;
        while (n2 < n) {
            PObject p = pObjectArray[n2];
            V r = p.get(slotKey, key);
            if (r != null) {
                if (this.cache()) {
                    this.put(slotKey, key, r);
                }
                return r;
            }
            ++n2;
        }
        return null;
    }

    public <K, V> K reverseGet(SlotKey<K, V> slotKey, V lookup) {
        K r = this.reverseGetOur(slotKey, lookup);
        if (r != null) {
            return r;
        }
        return this.reverseGetPrevious(slotKey, lookup);
    }

    public <K, V> K reverseGetOur(SlotKey<K, V> slotKey, V lookup) {
        Slot slot = this.getSlot(slotKey);
        if (slot != null) {
            for (Object k : slot.values.keySet()) {
                Object v = slot.values.get(k);
                if (!v.equals(lookup)) continue;
                return k;
            }
        }
        return null;
    }

    public <K, V> K reverseGetPrevious(SlotKey<K, V> slotKey, V lookup) {
        PObject[] pObjectArray = this.prototypes;
        int n = this.prototypes.length;
        int n2 = 0;
        while (n2 < n) {
            PObject p = pObjectArray[n2];
            K r = p.reverseGet(slotKey, lookup);
            if (r != null) {
                if (this.cache()) {
                    this.put(slotKey, r, lookup);
                }
                return r;
            }
            ++n2;
        }
        return null;
    }

    private void format(String prepend, StringBuilder sb) {
        sb.append(String.valueOf(prepend) + StringUtil.join("\n" + prepend, this.slots) + "\n");
        String prepend2 = "  " + prepend;
        PObject[] pObjectArray = this.prototypes;
        int n = this.prototypes.length;
        int n2 = 0;
        while (n2 < n) {
            PObject p = pObjectArray[n2];
            p.format(prepend2, sb);
            ++n2;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.format("", sb);
        return sb.toString();
    }

    private class Slot {
        private final Object key;
        private final Map values = new HashMap();

        Slot(Object key) {
            this.key = key;
        }

        public String toString() {
            return this.key + "\n" + this.values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SlotKey<K, V> {
        final String label;

        public SlotKey(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

