/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONValue;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JSONUtil {
    static ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        public List creatArrayContainer() {
            return new ArrayList();
        }

        public Map createObjectContainer() {
            return new LinkedHashMap();
        }
    };

    public static Object readObject(Reader r) throws IOException, ParseException {
        return new JSONParser().parse(r);
    }

    public static Object readObject(String s) {
        try {
            return new JSONParser().parse(s, CONTAINER_FACTORY);
        }
        catch (ParseException parseException) {
            throw new RuntimeException("not valid json: " + s);
        }
    }

    public static Map readMap(Reader r) throws IOException, ParseException {
        Object o = JSONUtil.readObject(r);
        if (!(o instanceof Map)) {
            throw new RuntimeException("expected map, got " + o);
        }
        return (Map)o;
    }

    public static List readList(String s) {
        Object o = JSONUtil.readObject(s);
        if (!(o instanceof List)) {
            throw new RuntimeException("expected map, got " + o);
        }
        return (List)o;
    }

    public static Map readMap(String s) {
        Object o = JSONUtil.readObject(s);
        if (!(o instanceof Map)) {
            throw new RuntimeException("expected map, got " + o);
        }
        return (Map)o;
    }

    public static String stringify(Object o) throws IOException {
        StringWriter sw = new StringWriter();
        JSONValue.writeJSONString(o, sw);
        return sw.toString();
    }

    public static void writeObject(Writer w, Object o) throws IOException {
        try {
            JSONValue.writeJSONString(o, w);
        }
        finally {
            w.close();
        }
    }

    public static void writeObject(File file, Object o) throws IOException {
        JSONUtil.writeObject(new FileWriter(file), o);
    }

    public static void writeObjectOrError(File file, Object o) {
        try {
            JSONUtil.writeObject(new FileWriter(file), o);
        }
        catch (Exception e) {
            throw new Error("Unable to write: " + file, e);
        }
    }

    public static Object readObjectOrError(File f) {
        try {
            return JSONUtil.readMap(new FileReader(f));
        }
        catch (Exception e) {
            throw new Error("Unable to read: " + f, e);
        }
    }
}

