/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.ConversionInstance;
import org.simpleframework.xml.core.Factory;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.core.InstantiationException;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.InputNode;

class MapFactory
extends Factory {
    public MapFactory(Context context, Type type) {
        super(context, type);
    }

    public Object getInstance() throws Exception {
        Class type = this.getType();
        Class real = type;
        if (!MapFactory.isInstantiable(real)) {
            real = this.getConversion(type);
        }
        if (!this.isMap(real)) {
            throw new InstantiationException("Type is not a collection %s", type);
        }
        return real.newInstance();
    }

    public Instance getInstance(InputNode node) throws Exception {
        Value value = this.getOverride(node);
        Class type = this.getType();
        if (value != null) {
            return this.getInstance(value);
        }
        if (!MapFactory.isInstantiable(type)) {
            type = this.getConversion(type);
        }
        if (!this.isMap(type)) {
            throw new InstantiationException("Type is not a map %s", type);
        }
        return this.context.getInstance(type);
    }

    public Instance getInstance(Value value) throws Exception {
        Class type = value.getType();
        if (!MapFactory.isInstantiable(type)) {
            type = this.getConversion(type);
        }
        if (!this.isMap(type)) {
            throw new InstantiationException("Type is not a map %s", type);
        }
        return new ConversionInstance(this.context, value, type);
    }

    public Class getConversion(Class type) throws Exception {
        if (type.isAssignableFrom(HashMap.class)) {
            return HashMap.class;
        }
        if (type.isAssignableFrom(TreeMap.class)) {
            return TreeMap.class;
        }
        throw new InstantiationException("Cannot instantiate %s", type);
    }

    private boolean isMap(Class type) {
        return Map.class.isAssignableFrom(type);
    }
}

