/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.BuildPluginDef;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.RepositoryInstance;
import ebuild.core.RepositoryRef;
import ebuild.core.impl.DependencyType;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Version;
import ebuild.core.util.PObject;
import ebuild.util.Callable;
import ebuild.util.tuple.Pair;
import ebuild.xml.CmnXml;
import java.util.HashMap;
import java.util.Map;

public abstract class EBuildContext {
    private static final PObject.SlotKey<String, BuildPluginDef> BUILDERS = new PObject.SlotKey("BUILDERS");
    private static final PObject.SlotKey<String, RepositoryRef> REPOSITORIES = new PObject.SlotKey("REPOSITORIES");
    private Map<Object, BuildPluginDef> localBuildPluginDefMap = new HashMap<Object, BuildPluginDef>(0);
    private final PObject pobj = new PObject();
    final EBuild ebuild;
    private Map<Pair<String, KeyE>, Element> resolvedElements = new HashMap<Pair<String, KeyE>, Element>();

    public EBuildContext(EBuild ebuild) {
        this.ebuild = ebuild;
    }

    public abstract Object getKey();

    public abstract boolean isInited();

    public Version assignDefaults(RepositoryRef repoRef, KeyE dkey0) throws EBuildException {
        Version dversion = (Version)dkey0.getVersion();
        return dversion.withDefault(Version.TRUNK_HEAD);
    }

    public void addParents(EBuildContext ... parentContexts) {
        PObject[] prototypes = new PObject[parentContexts.length];
        int j = 0;
        EBuildContext[] eBuildContextArray = parentContexts;
        int n = parentContexts.length;
        int n2 = 0;
        while (n2 < n) {
            EBuildContext parentContext = eBuildContextArray[n2];
            prototypes[j] = parentContext.pobj;
            ++j;
            ++n2;
        }
        this.pobj.addPrototypes(prototypes);
    }

    public BuildPluginDef getBuildPluginDefById(String id) {
        return this.pobj.get(BUILDERS, id);
    }

    public void addBuildPluginDef(Object localKey, String id, BuildPluginDef value) {
        if (id != null) {
            this.pobj.put(BUILDERS, id, value);
        }
        this.localBuildPluginDefMap.put(localKey, value);
    }

    public BuildPluginDef expectBuildPluginDefById(String id) throws EBuildException {
        BuildPluginDef r = this.getBuildPluginDefById(id);
        if (r == null) {
            throw EBuildException.newConfProblem("No such build plugin in scope: " + id);
        }
        return r;
    }

    public BuildPluginDef expectBuildPluginDefByLocalKey(Object localKey) throws EBuildException {
        BuildPluginDef r = this.localBuildPluginDefMap.get(localKey);
        if (r == null) {
            throw new Error("Build plugin not registered: " + localKey);
        }
        return r;
    }

    public RepositoryRef getRepository(String key) {
        return this.pobj.get(REPOSITORIES, key);
    }

    public RepositoryRef addRepository(RepositoryRef value) {
        this.pobj.put(REPOSITORIES, value.name, value);
        return value;
    }

    public RepositoryRef addLocalRepository(RepositoryInstance repository, String defaultOrg) {
        RepositoryRef.LocalRef r = new RepositoryRef.LocalRef(this, repository);
        r.setDefaultOrg(defaultOrg);
        return this.addRepository(r);
    }

    public RepositoryRef addNamedRepository(String name, RepositoryInstance repository, String defaultOrg) throws EBuildException {
        if ("local".equals(name)) {
            throw EBuildException.newConfProblem("Cannot name a repository 'local'");
        }
        RepositoryRef.NamedRef r = new RepositoryRef.NamedRef(this, name, repository);
        r.setDefaultOrg(defaultOrg);
        return this.addRepository(r);
    }

    public void addRepository(final CmnXml.Repository repoXml) throws EBuildException {
        RepositoryRef r;
        String msg = repoXml.validate();
        if (msg != null) {
            throw EBuildException.newConfProblem("Invalid repository definition: " + msg);
        }
        if (repoXml.ref != null) {
            RepositoryRef prototype = this.getRepository(repoXml.ref);
            Version v = EBuildUtil.asVersion(repoXml);
            if (v == null && prototype.isLocal()) {
                throw EBuildException.newConfProblem("Unsupported operation. Not currently possible to derive from a local reference: " + prototype.name);
            }
            r = new RepositoryRef.DerivedRef(prototype, this, repoXml.name);
            this.addRepository(r);
        } else {
            r = new RepositoryRef.LazyRef(this, repoXml.name, null, new Callable<RepositoryInstance, EBuildException>(){

                @Override
                public RepositoryInstance run() throws EBuildException {
                    return EBuildContext.this.ebuild.REPOS.getRepository(repoXml.type, repoXml.url);
                }
            });
            this.addRepository(r);
        }
        r.setDefaultOrg(repoXml.org);
        r.setDefaultVersion(EBuildUtil.asVersion(repoXml));
    }

    public RepositoryRef lookupRepository(String source) throws EBuildException {
        if ("system".equals(source)) {
            return null;
        }
        RepositoryRef repo = this.getRepository(source);
        if (repo == null) {
            if (!this.isInited()) {
                throw new Error("Context not initialised " + this + " " + source);
            }
            throw EBuildException.newConfProblem("Bad source, no repository defined in scope '" + this + "'for '" + source + "'");
        }
        return repo;
    }

    protected abstract Element resolveMoving(RepositoryRef var1, KeyE var2) throws EBuildException;

    public Element resolveElement(DependencyType type, String source, KeyE dkey) throws EBuildException {
        Backtrace.start("resolve", dkey);
        try {
            Pair<String, KeyE> key = new Pair<String, KeyE>(source, dkey);
            Element r = this.resolvedElements.get(key);
            if (r == null) {
                r = this.resolveElementInner(source, dkey);
                if (r == null) {
                    throw EBuildException.newConfProblem("No such element: " + dkey);
                }
                this.resolvedElements.put(key, r);
            }
            this.ebuild.report.resolve(type, dkey, r);
            Element element = r;
            return element;
        }
        finally {
            Backtrace.end(dkey);
        }
    }

    Element resolveLibraryPart(RepositoryRef repoRef, KeyE key) throws EBuildException {
        return this.ebuild.LIBRARY.resolveElement(repoRef, key);
    }

    Element resolveElementInner(String source, KeyE dkey0) throws EBuildException {
        RepositoryRef repoRef = this.lookupRepository(source);
        KeyE dkey = dkey0.withVersion(this.assignDefaults(repoRef, dkey0));
        if (dkey.version.isMoving()) {
            if (repoRef.xmlContextTrait == null && !dkey.version.isWorking()) {
                throw EBuildException.newConfProblem("Element source '" + repoRef.name + "' does not support moving version '" + dkey.version.getRevision() + "'");
            }
            return this.resolveMoving(repoRef, dkey);
        }
        return this.resolveLibraryPart(repoRef, dkey);
    }
}

