/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.base.EBuildException;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.Element;
import ebuild.core.RepositoryRef;
import ebuild.core.WorkspaceProject;
import ebuild.core.impl.DependencyType;
import ebuild.core.impl.KeyE;

public class EBuildContextOfRoot
extends EBuildContext {
    public final String name;

    public EBuildContextOfRoot(EBuild ebuild, String name) {
        super(ebuild);
        this.name = name;
    }

    public Object getKey() {
        return this.name;
    }

    public boolean isInited() {
        return true;
    }

    public Element resolveWorkspaceElement(String projectDir) throws EBuildException {
        WorkspaceProject wproj = this.ebuild.WORKSPACES.getWorkspaceProject(projectDir);
        if (wproj == null) {
            return null;
        }
        Element r = wproj.getPrimary();
        this.ebuild.report.resolve(DependencyType.TOP, r.key, r);
        return r;
    }

    protected Element resolveMoving(RepositoryRef repoRef, KeyE dkey) throws EBuildException {
        String revision = repoRef.getRepo().asSource().getRevisionOfHead();
        dkey = dkey.withRevision(revision);
        return this.resolveLibraryPart(repoRef, dkey);
    }

    public String toString() {
        return this.name;
    }
}

