/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.core.BuildPluginDef;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.Element;
import ebuild.core.MetaDir;
import ebuild.core.Module;
import ebuild.core.ProjectHelper;
import ebuild.core.RepositoryRef;
import ebuild.core.WorkspaceProject;
import ebuild.core.conf.ConfMapping;
import ebuild.core.impl.DependencyType;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.UpstreamRevisions;
import ebuild.core.impl.Version;
import ebuild.xml.CmnXml;
import java.util.Map;

public class EBuildContextOfXml
extends EBuildContext {
    public final Element element;
    final Type type;
    public final UpstreamRevisions UPSTREAM_REVISIONS;
    private boolean inited = false;

    private EBuildContextOfXml(EBuild ebuild, Element element, Type type) {
        super(ebuild);
        this.element = element;
        this.type = type;
        MetaDir metaDir = element.META.getMetaDir();
        this.UPSTREAM_REVISIONS = metaDir != null ? new UpstreamRevisions(metaDir.getUpstreamRevisions(this.getMetaType())) : null;
    }

    public EBuildContextOfXml(Element element, Type type) {
        this(element.ebuild, element, type);
    }

    public boolean isInited() {
        return this.inited;
    }

    public void init() {
        this.inited = true;
    }

    public Object getKey() {
        return this.element.key;
    }

    public Version assignDefaults(RepositoryRef repoRef, KeyE dkey0) throws EBuildException {
        Version defaultVersion = repoRef.getDefaultVersion(dkey0.org, dkey0.name);
        Version dversion = (Version)dkey0.getVersion();
        if (defaultVersion != null) {
            return dversion.withDefault(defaultVersion);
        }
        Version eversion = (Version)this.element.key.getVersion();
        if (repoRef.getRepo() == this.element.getRepository()) {
            return dversion.withDefault(eversion);
        }
        if ("[ours]".equals(dversion.getBranch())) {
            dversion = dversion.withBranch(eversion.getBranch());
        }
        return super.assignDefaults(repoRef, dkey0);
    }

    public EBuildContextOfXml resolveSelf() throws EBuildException {
        if (this.isInited()) {
            return this;
        }
        if (this.type.isBuild()) {
            this.resolveSelfBuild(this.element.expectProjectHelper());
        } else {
            this.resolveSelf(this.element.getMETA().expectMainXml());
        }
        return this;
    }

    private EBuildContextOfXml resolveSelfBuild(ProjectHelper phelper) throws EBuildException {
        this.resolveSelf(this.element.PROJECT.META.expectBuildXml());
        Backtrace.start("resolve " + this.element.builderName() + "s", this);
        this.ebuild.report.startResolve(this, String.valueOf(this.element.builderName()) + "s");
        try {
            Map<Object, ? extends CmnXml.SelectBuildPlugin> bdeps = this.element.PROJECT.META.getBuildDependencies();
            for (Object k : bdeps.keySet()) {
                BuildPluginDef pluginDef;
                CmnXml.SelectBuildPlugin bxml = bdeps.get(k);
                ConfMapping mapping = EBuildUtil.parseMapping(bxml.confMapping);
                if (bxml.refid != null) {
                    BuildPluginDef prototype = this.expectBuildPluginDefById(bxml.refid);
                    pluginDef = prototype.clone(mapping, bxml.propertiesList);
                } else {
                    KeyE bkeyE = this.newModuleKeyE(bxml);
                    Module bmodule = this.resolveModule(DependencyType.BUILDER, bxml.source, bkeyE);
                    pluginDef = phelper.newBuildPluginDef(bmodule, mapping, bxml.propertiesList);
                }
                this.addBuildPluginDef(k, bxml.id, pluginDef);
            }
        }
        finally {
            Backtrace.end(this);
        }
        this.ebuild.report.endResolve();
        return this;
    }

    private EBuildContextOfXml resolveSelf(CmnXml.EBuildRoot xml) throws EBuildException {
        String contextNoun = String.valueOf(this.type.name()) + " context";
        Backtrace.start("resolving " + contextNoun, this);
        try {
            EBuildContextOfXml eBuildContextOfXml = this.resolveSelfInner(xml, contextNoun);
            return eBuildContextOfXml;
        }
        finally {
            Backtrace.end(this);
            this.init();
        }
    }

    private EBuildContextOfXml resolveSelfInner(CmnXml.EBuildRoot xml, String contextNoun) throws EBuildException {
        this.addParents(this.ebuild.context);
        for (CmnXml.Repository repoXml : xml.repositories) {
            this.addRepository(repoXml);
        }
        int l = xml.usings.size();
        EBuildContext[] add = new EBuildContextOfXml[l];
        this.ebuild.report.startResolve(this, contextNoun);
        int i = 0;
        while (i < l) {
            CmnXml.Using d = xml.usings.get(i);
            KeyE dkey = this.newElementKeyE(ElementType.module, d);
            Module delement = this.resolveModule(DependencyType.CONF, d.source, dkey);
            EBuildContextOfXml dcontext = d.isBuild() ? delement.expectProjectHelper().contextOfBuild.resolveSelf() : delement.context.resolveSelf();
            add[i] = dcontext;
            ++i;
        }
        this.ebuild.report.endResolve();
        this.addParents(add);
        return this;
    }

    public KeyE newProductKeyE(CmnXml.SelectWithSource select) throws EBuildException {
        return this.newElementKeyE(ElementType.product, select);
    }

    public KeyE newModuleKeyE(CmnXml.SelectWithSource select) throws EBuildException {
        return this.newElementKeyE(ElementType.module, select);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KeyE newElementKeyE(ElementType type, CmnXml.SelectWithSource select) throws EBuildException {
        String universe;
        String source = select.source;
        String name = select.name;
        if (source == null) {
            throw EBuildException.newConfProblem("'source' not set: " + select);
        }
        if (name == null) {
            throw EBuildException.newConfProblem("'name' not set: " + select);
        }
        boolean local = "local".equals(select.source);
        String org = select.org;
        Version version = EBuildUtil.asVersion(select);
        KeyE ourKey = this.element.key;
        if (local) {
            universe = ourKey.universe;
            if (version == null) {
                Version ourV = ourKey.version;
                version = ourV.isTag() ? (ourV.hasTagSub() ? ourV.withoutTagSub() : ourV) : ourV.withRevision("head");
            }
        } else {
            RepositoryRef repoRef = this.lookupRepository(select.source);
            if (repoRef == null) {
                if (!"system".equals(source)) throw EBuildException.newConfProblem("Unknown source: " + source);
                universe = source;
            } else {
                universe = repoRef.getUniverse();
                if (org == null) {
                    org = repoRef.getDefaultOrg();
                }
                if (version == null) {
                    version = repoRef.getDefaultVersion(org, name);
                }
            }
        }
        if (org == null) {
            org = ourKey.org;
        }
        if (version != null) return new KeyE(type, universe, org, name, version);
        version = "machine".equals(source) ? Version.newTag("*") : Version.DEFAULT;
        return new KeyE(type, universe, org, name, version);
    }

    public Module resolveModule(DependencyType depType, String source, KeyE dkey) throws EBuildException {
        return (Module)this.resolveElement(depType, source, dkey);
    }

    private Element resolveLibraryWithFixedRevision(RepositoryRef repoRef, KeyE dkey, String revision) throws EBuildException {
        Version v2 = dkey.version.withRevision(revision);
        KeyE dkey2 = dkey.withVersion(v2);
        Element r = this.resolveLibraryPart(repoRef, dkey2);
        if (repoRef.isLocal()) {
            this.UPSTREAM_REVISIONS.putLocal(r.key);
        }
        return r;
    }

    protected Element resolveMoving(RepositoryRef repoRef, KeyE dkey) throws EBuildException {
        RepositoryRef.XmlContextRefTrait xrepoRef = repoRef.xmlContextTrait;
        if (this.element == null || this.element.isWorkspace()) {
            WorkspaceProject wsp = this.ebuild.WORKSPACES.getWorkspaceProject(dkey);
            if (wsp != null && xrepoRef.fixRevisionToWorkspace(this, dkey)) {
                return wsp.getElement(dkey.type);
            }
            if (!repoRef.isSource()) {
                String msg = "Repository '" + repoRef.name + "' does not support head versions";
                if (!repoRef.hasRepo()) {
                    msg = String.valueOf(msg) + " (project not connected to a repository)";
                }
                throw EBuildException.newConfProblem(String.valueOf(msg) + ":" + dkey);
            }
            String revision = xrepoRef.getUpdatedFixedRevision(this, dkey);
            return this.resolveLibraryWithFixedRevision(repoRef, dkey, revision);
        }
        String revision = xrepoRef.expectFixedRevision(dkey);
        return this.resolveLibraryWithFixedRevision(repoRef, dkey, revision);
    }

    MetaType getMetaType() {
        return this.element.META.getMetaType();
    }

    public String toString() {
        return this.element + "," + this.type.filename();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        product(MetaType.PRODUCT),
        product_assembly(MetaType.PRODUCT_ASSEMBLY),
        module(MetaType.MODULE),
        module_build(MetaType.MODULE_BUILD);

        final MetaType metaType;

        private Type(MetaType metaType) {
            this.metaType = metaType;
        }

        String displayName() {
            return (Object)((Object)this) + "".replace('_', '-') + " context";
        }

        String filename() {
            return this.metaType.name;
        }

        boolean isMain() {
            return this == module || this == product;
        }

        boolean isBuild() {
            return this == module_build || this == product_assembly;
        }

        public String builderName() {
            if (this == module_build) {
                return "builders";
            }
            if (this == product_assembly) {
                return "assemblers";
            }
            return null;
        }

        public String elementName() {
            switch (this) {
                case module: 
                case module_build: {
                    return "module";
                }
                case product: 
                case product_assembly: {
                    return "product";
                }
            }
            return null;
        }
    }
}

