/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IArtifact;
import ebuild.api.IModuleWorkspaceProject;
import ebuild.api.common.Scope;
import ebuild.base.EBuildException;
import ebuild.core.Artifact;
import ebuild.core.ElementDeps;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleReleaseArtifact;
import ebuild.core.ModuleWorkspaceProject;
import ebuild.core.ProductDeps;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.KeyE;
import ebuild.util.CollectionUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDeps
extends ElementDeps {
    public final ModuleDeps parent;
    public final Module module;
    public final Scope scope;
    public final Map<String, ProductDeps.ProductDep> products = new HashMap<String, ProductDeps.ProductDep>();
    private final Set<String> groups = new HashSet<String>();
    private final Map<KeyE, ModuleDep> elements = new LinkedHashMap<KeyE, ModuleDep>();
    private final Map<KeyE, CheckedInDep> checkedIns = new LinkedHashMap<KeyE, CheckedInDep>();
    private final Map<KeyE, SystemDep> systems = new LinkedHashMap<KeyE, SystemDep>();

    public ModuleDeps(ModuleC moduleC, Scope scope, ModuleDeps parent) {
        this.module = (Module)moduleC.element;
        this.scope = scope;
        this.parent = parent;
        if (parent != null) {
            this.groups.addAll(parent.groups);
        }
        assert (scope.getParent() != null || parent == null);
        assert (scope.getParent() == null || parent != null);
    }

    public Collection<String> getLoadGroups() {
        return this.groups;
    }

    public Iterable<ModuleDep> getModuleDeps() {
        if (this.parent == null) {
            return this.elements.values();
        }
        return CollectionUtil.concat(this.parent.getModuleDeps(), this.elements.values());
    }

    public Iterable<CheckedInDep> getCheckedInDeps() {
        if (this.parent == null) {
            return this.checkedIns.values();
        }
        return CollectionUtil.concat(this.parent.getCheckedInDeps(), this.checkedIns.values());
    }

    public Iterable<SystemDep> getSystemDeps() {
        if (this.parent == null) {
            return this.systems.values();
        }
        return CollectionUtil.concat(this.parent.getSystemDeps(), this.systems.values());
    }

    public void addModule(ModuleDep dep) {
        if (dep.loadgroup != null) {
            this.groups.add(dep.loadgroup);
        }
        this.elements.put(dep.key, dep);
    }

    public void addCheckedIn(CheckedInDep dep) {
        this.checkedIns.put(dep.key, dep);
    }

    public void addSystem(SystemDep dep) {
        this.systems.put(dep.key, dep);
    }

    public void addProduct(ProductDeps.ProductDep dep) {
        this.products.put(dep.key, dep);
    }

    @Override
    public long lastModified() throws EBuildException {
        long r = Long.MIN_VALUE;
        for (ModuleC m : this.builders.values()) {
            r = Math.max(r, m.lastModification(Scope.MAIN));
        }
        for (ModuleDep pd : this.elements.values()) {
            r = Math.max(r, pd.moduleC.lastModification(Scope.MAIN));
        }
        for (CheckedInDep cid : this.checkedIns.values()) {
            r = Math.max(r, cid.getFile().lastModified());
        }
        return r;
    }

    public Map<KeyE, AbstractDep> getAll() {
        HashMap<KeyE, AbstractDep> r = new HashMap<KeyE, AbstractDep>();
        r.putAll(this.elements);
        return r;
    }

    public void doDeepGather(Gatherer gatherer, RecurseRule rule, Exclude exclude) {
        for (SystemDep sd : this.getSystemDeps()) {
            gatherer.add(sd);
        }
        for (CheckedInDep cd : this.getCheckedInDeps()) {
            gatherer.add(cd);
        }
        for (ModuleDep md : this.getModuleDeps()) {
            if (exclude.match(md.key) || rule.ignore(md)) continue;
            if (rule.use(md)) {
                gatherer.add(md);
            }
            ModuleDeps mddeps = md.getDependencies();
            mddeps.doDeepGather(gatherer, gatherer.continueRule, md.exclude);
        }
    }

    public IArtifact getProduct(String role) {
        IArtifact r = null;
        for (ModuleDep md : this.getModuleDeps()) {
            ModuleDeps mddeps = md.getDependencies();
            IArtifact p = mddeps.getProduct(role);
            if (p == null) continue;
            r = p;
        }
        IArtifact p = this.products.get(role);
        if (p != null) {
            r = p;
        }
        return r;
    }

    public String toString() {
        return this.scope + " dependencies of " + this.module;
    }

    static abstract class AbstractDep {
        public final Scope scope;
        public final KeyE key;

        AbstractDep(Scope scope, KeyE key) {
            this.scope = scope;
            this.key = key;
        }
    }

    public class CheckedInDep
    extends AbstractDep {
        String type;

        public CheckedInDep(Scope scope, String name, String type) {
            super(scope, KeyE.newUnversioned("checkedin", null, name));
            this.type = type;
        }

        File getFile() {
            File dir = new File(ModuleDeps.this.module.getProjectDirectory(), "checkedin");
            return new File(dir, this.key.name);
        }
    }

    public static abstract class Gatherer {
        private RecurseRule continueRule = RecurseRule.DEFAULT_CONT;

        Gatherer() {
        }

        public void setContinueRule(RecurseRule continueRule) {
            this.continueRule = continueRule;
        }

        public abstract void add(ModuleDep var1);

        public abstract void add(SystemDep var1);

        public abstract void add(CheckedInDep var1);
    }

    public static class GathererOfFiles
    extends Gatherer {
        public final String[] artifactTypes;
        public final Set<File> files = new LinkedHashSet<File>();
        private final boolean ideSetup;

        public GathererOfFiles(boolean ideSetup, String ... artifactTypes) {
            this.ideSetup = ideSetup;
            this.artifactTypes = artifactTypes;
        }

        public void add(ModuleDep dep) {
            String[] stringArray = this.artifactTypes;
            int n = this.artifactTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String at = stringArray[n2];
                this.files.addAll(dep.getArtifactFiles(this.ideSetup, at));
                ++n2;
            }
        }

        public void add(Artifact.Module mr) {
            if (mr != null) {
                this.files.addAll(mr.getArtifactFiles());
            }
        }

        public void add(SystemDep dep) {
            String[] stringArray = this.artifactTypes;
            int n = this.artifactTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String at = stringArray[n2];
                File f = dep.getFile(at);
                if (f != null && f.exists()) {
                    this.files.add(f);
                }
                ++n2;
            }
        }

        public void add(CheckedInDep dep) {
            String[] stringArray = this.artifactTypes;
            int n = this.artifactTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String at = stringArray[n2];
                if (at.equals(dep.type)) {
                    this.files.add(dep.getFile());
                }
                ++n2;
            }
        }

        public String toString() {
            String r = "Gathered:-\n";
            for (File f : this.files) {
                r = String.valueOf(r) + "    " + f + "\n";
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GathererOfModuleSelection
    extends Gatherer {
        final String[] artifactTypes;
        public final Set<File> files = new LinkedHashSet<File>();
        public final Map<KeyE, Collection<ModuleReleaseArtifact>> releases = new LinkedHashMap<KeyE, Collection<ModuleReleaseArtifact>>();

        public GathererOfModuleSelection() {
            this(null);
        }

        public GathererOfModuleSelection(String[] artifactTypes) {
            this.artifactTypes = artifactTypes;
        }

        @Override
        public void add(ModuleDep dep) {
            this.add(dep.moduleC);
        }

        public void add(ModuleC moduleC) {
            KeyE keyE = moduleC.key.ekey;
            this.releases.put(keyE, moduleC.getReleases(this.artifactTypes).values());
        }

        @Override
        public void add(SystemDep dep) {
            String[] stringArray = this.artifactTypes;
            int n = this.artifactTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String at = stringArray[n2];
                File f = dep.getFile(at);
                if (f != null && f.exists()) {
                    this.files.add(f);
                }
                ++n2;
            }
        }

        @Override
        public void add(CheckedInDep dep) {
            String[] stringArray = this.artifactTypes;
            int n = this.artifactTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String at = stringArray[n2];
                if (at.equals(dep.type)) {
                    this.files.add(dep.getFile());
                }
                ++n2;
            }
        }

        public Collection<File> getFiles() {
            Set<File> r = this.files;
            for (Collection<ModuleReleaseArtifact> artifacts : this.releases.values()) {
                for (ModuleReleaseArtifact a : artifacts) {
                    r.addAll(a.getArtifactFiles());
                }
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GathererOfReleases
    extends Gatherer {
        public final Set<Artifact> releases = new LinkedHashSet<Artifact>();

        @Override
        public void add(ModuleDep dep) {
            this.releases.addAll(dep.moduleC.getReleases().values());
        }

        public Set<Artifact.Module> getModules() {
            HashSet<Artifact.Module> r = new HashSet<Artifact.Module>();
            for (Artifact a : this.releases) {
                if (!(a instanceof Artifact.Module)) continue;
                r.add((Artifact.Module)a);
            }
            return r;
        }

        @Override
        public void add(SystemDep dep) {
        }

        @Override
        public void add(CheckedInDep dep) {
        }
    }

    public static class GathererOfWSProjects
    extends Gatherer {
        public final Set<IModuleWorkspaceProject> projects = new LinkedHashSet<IModuleWorkspaceProject>();

        public void add(ModuleDep dep) {
            ModuleWorkspaceProject wp = dep.moduleC.getWorkspaceProject();
            if (wp != null) {
                this.projects.add(wp);
            }
        }

        public void add(SystemDep dep) {
        }

        public void add(CheckedInDep dep) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModuleDep
    extends AbstractDep {
        public final ModuleC moduleC;
        public final boolean subsumed;
        public final String loadgroup;
        public final Exclude exclude;

        public ModuleDep(Scope scope, ModuleC cElement, boolean subsumed, String loadgroup, Exclude exclude) {
            super(scope, ((Module)cElement.getPart()).key);
            this.moduleC = cElement;
            this.subsumed = subsumed;
            this.loadgroup = loadgroup;
            this.exclude = exclude;
            assert (exclude != null);
        }

        public ModuleDeps getDependencies() {
            return this.moduleC.getDependencies(Scope.MAIN);
        }

        public Artifact.Module getRelease(String artifact) {
            return this.moduleC.getCompiled().getRelease(artifact);
        }

        public Collection<File> getArtifactFiles(boolean fromWorkspace, String artifactType) {
            if (fromWorkspace && ((Module)this.moduleC.element).isWorkspace()) {
                File r = this.moduleC.getWorkspaceProject().getOutputArtifact(Scope.MAIN, artifactType, false);
                if (!r.exists()) {
                    return CollectionUtil.EMPTY_LIST;
                }
                return CollectionUtil.newList(r);
            }
            Artifact.Module mr = this.getRelease(artifactType);
            if (mr == null) {
                return CollectionUtil.EMPTY_LIST;
            }
            return mr.getArtifactFiles();
        }

        public boolean isWorkspace() {
            return this.moduleC.eclipse != null;
        }

        public String toString() {
            return "subsumed=" + this.subsumed + " " + this.moduleC;
        }
    }

    public static abstract class RecurseRule {
        protected static final RecurseRule DEFAULT_CONT = new RecurseRule(){

            public boolean ignore(ModuleDep md) {
                if (md.subsumed) {
                    return true;
                }
                return md.loadgroup != null;
            }
        };

        public boolean ignore(ModuleDep md) {
            return false;
        }

        public boolean use(ModuleDep md) {
            return true;
        }
    }

    public class SystemDep
    extends AbstractDep {
        public SystemDep(Scope scope, String name, String tag) {
            super(scope, KeyE.newTagged(null, "system", "system", name, tag));
        }

        public String name() {
            return this.key.name;
        }

        public File getFile(String artifactType) {
            String prop;
            if ("java_classes.jar".equals(artifactType) && "java.jdk.tools".equals(this.name()) && (prop = ModuleDeps.this.module.ebuild.getSettingProp("java.jdk.tools")) != null) {
                return new File(prop);
            }
            return null;
        }
    }
}

