/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IAssemblerArgument;
import ebuild.api.IEBuild;
import ebuild.api.IInputMap;
import ebuild.api.common.IElementKey;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.base.EBuildException;
import ebuild.base.EBuildLogger;
import ebuild.core.Artifact;
import ebuild.core.AssemblerDef;
import ebuild.core.AssemblerInstance;
import ebuild.core.BuildProject;
import ebuild.core.EBuild;
import ebuild.core.EBuildContextOfXml;
import ebuild.core.Product;
import ebuild.core.ProductBuildMeta;
import ebuild.core.ProductC;
import ebuild.core.ProductDeps;
import ebuild.core.ProductProjectHelper;
import ebuild.core.ProductReleaseArtifact;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.Input;
import ebuild.core.impl.InputMap;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.xml.PrdXml;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ProductBuildProject
extends BuildProject {
    private final EBuild ebuild;
    private final Product product;
    private final ProductC productC;
    private final ProductBuildMeta.AssemblyVisitor<ArtifactGenerator> generatorFactory;

    public ProductBuildProject(ProductC elementC) {
        super(elementC);
        this.productC = elementC;
        this.product = (Product)elementC.element;
        this.ebuild = this.product.ebuild;
        ProductProjectHelper phelper = this.product.getProjectHelper();
        final EBuildContextOfXml context = phelper.contextOfBuild;
        ProductBuildMeta productBuildMeta = this.product.getProject().getMETA();
        productBuildMeta.getClass();
        this.generatorFactory = new ProductBuildMeta.AssemblyVisitor<ArtifactGenerator>(productBuildMeta, this.getConfiguration()){

            @Override
            ArtifactGenerator visitGroup(String path, PrdXml.AssemblyGroup group, List<ArtifactGenerator> members) {
                if (members.size() == 1) {
                    return members.get(0);
                }
                return new AssemblyGroup(path, members);
            }

            @Override
            ArtifactGenerator visitAssembler(String path, PrdXml.Assembler assemblerXml, Map<String, ArtifactGenerator> inputs) throws EBuildException {
                AssemblerDef adef = (AssemblerDef)context.expectBuildPluginDefByLocalKey(path);
                AssemblerInstance ainstance = adef.instantiate(ProductBuildProject.this.productC.getConfiguration());
                return new AssemblerGenerator(path, ainstance, inputs);
            }

            @Override
            ArtifactGenerator visitProduct(String path, PrdXml.Product product) throws EBuildException {
                ProductDeps deps = ProductBuildProject.this.productC.getDependencies();
                ProductDeps.ProductDep dep = deps.products.get(path);
                ProductReleaseArtifact release = (ProductReleaseArtifact)dep.productC.expectRelease(dep.artifact);
                return new ComponentSelect(path, release);
            }

            @Override
            ArtifactGenerator visitModuleSelection(String path, PrdXml.ModuleSelection ms) throws EBuildException {
                Exclude excludes = Exclude.newExclude(ms.excludes);
                ProductDeps deps = ProductBuildProject.this.productC.getDependencies();
                ProductDeps.ModuleSelectionDep dep = deps.moduleSelections.get(path);
                String[] artifactTypes = ms.artifact.split(",");
                Collection<File> artifacts = dep.getArtifacts(excludes, artifactTypes);
                return new ModuleSelectionInstance(path, artifacts);
            }
        };
    }

    public long releaseLastModified() {
        long r = Long.MIN_VALUE;
        for (Artifact release : this.productC.getReleases().values()) {
            File[] fileArray = release.getRoots();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                r = Math.max(r, FileUtil.deepLastModified(f));
                ++n2;
            }
        }
        return r;
    }

    public void buildRun() throws EBuildException {
        for (String artifact : this.productC.getReleases().keySet()) {
            Collection<File> artifacts;
            ProductReleaseArtifact release = this.productC.getRelease(artifact);
            ArtifactGenerator releaseGenerator = this.generatorFactory.go(artifact);
            try {
                artifacts = releaseGenerator.assemble(this.ebuild);
            }
            catch (EBuildException e) {
                throw EBuildException.wrapException("Problem with product assembly of artifact '" + artifact + "' of '" + this.productC.key + "'", e);
            }
            if (artifacts.size() != 1) {
                throw EBuildException.newConfProblem("Expected single artifact from release " + artifact + ", got " + artifacts.size());
            }
            File a = artifacts.iterator().next();
            EBuildLogger logger = this.ebuild.logger;
            logger.log("releasing '" + artifact + "'");
            logger.log("    " + this.ebuild.formatAsDisplayPath(a));
            logger.log(" -> " + this.ebuild.formatAsDisplayPath(release.artifactFile));
            try {
                FileUtil.copy(a, release.artifactFile);
            }
            catch (IOException e) {
                throw EBuildException.newInternalError("Problem copying release", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class ArtifactGenerator {
        protected final String path;
        private final File outputDir;
        private Collection<File> artifacts = null;

        public ArtifactGenerator(String path) {
            this.path = path;
            this.outputDir = new File(ProductBuildProject.this.getIntermediateDirectory(), path);
        }

        final Collection<File> assemble(EBuild ebuild) throws EBuildException {
            if (this.artifacts == null) {
                this.artifacts = this.assemble_(ebuild);
            }
            return this.artifacts;
        }

        abstract Collection<File> assemble_(EBuild var1) throws EBuildException;

        public File useOutputDir() {
            this.outputDir.mkdirs();
            return this.outputDir;
        }

        public String toString() {
            return String.valueOf(this.path) + " - " + this.getClass().getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AssemblerGenerator
    extends ArtifactGenerator {
        final AssemblerInstance instance;
        final Map<String, ArtifactGenerator> inputGenerators;

        public AssemblerGenerator(String path, AssemblerInstance instance, Map<String, ArtifactGenerator> inputGenerators) throws EBuildException {
            super(path);
            this.instance = instance;
            this.inputGenerators = inputGenerators;
        }

        @Override
        public Collection<File> assemble_(final EBuild ebuild) throws EBuildException {
            final InputMap inputs = new InputMap();
            for (String key : this.inputGenerators.keySet()) {
                ArtifactGenerator apc = this.inputGenerators.get(key);
                Collection<File> a = apc.assemble(ebuild);
                inputs.put(key, new Input(key, a));
            }
            IAssemblerArgument arg = new IAssemblerArgument(){

                public IEBuild getEBuild() {
                    return ebuild;
                }

                public ILogger getLogger() {
                    return ebuild.logger.newSubLogger("Assembler/" + AssemblerGenerator.this.instance.key);
                }

                public IPropertyMap getPropertyMap() {
                    return AssemblerGenerator.this.instance.properties;
                }

                public IInputMap getInputMap() {
                    return inputs;
                }

                public File getOutputDirectory() {
                    return AssemblerGenerator.this.useOutputDir();
                }

                public Date getLastCommitDate() {
                    return ProductBuildProject.this.product.getLastCommitDate();
                }

                public IElementKey getProductKey() {
                    return ((ProductBuildProject)((AssemblerGenerator)AssemblerGenerator.this).ProductBuildProject.this).product.key;
                }

                public String getReleaseFileName() {
                    return ProductBuildProject.this.productC.getReleaseFileName(AssemblerGenerator.this.path);
                }
            };
            IPropertyMap props = arg.getPropertyMap();
            ILogger logger = arg.getLogger();
            logger.prime();
            logger.setProvisionalHeading("Properties");
            for (String k : props.listKeys()) {
                Object v = props.get(k);
                logger.log("    " + k + ": " + v);
            }
            try {
                return this.instance.assembler.assemble(arg);
            }
            catch (BuildPluginException e) {
                throw EBuildException.newPluginProblem("Unable to assemble target or subtarget '" + this.path + "'", e);
            }
        }

        @Override
        public String toString() {
            return String.valueOf(this.path) + " - AssemblerGenerator - " + this.instance.getClass().getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AssemblyGroup
    extends ArtifactGenerator {
        final List<ArtifactGenerator> generators;

        AssemblyGroup(String path, List<ArtifactGenerator> generators) {
            super(path);
            this.generators = generators;
        }

        @Override
        public Collection<File> assemble_(EBuild ebuild) throws EBuildException {
            ArrayList<File> r = new ArrayList<File>(this.generators.size());
            for (ArtifactGenerator g : this.generators) {
                r.addAll(g.assemble(ebuild));
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComponentSelect
    extends ArtifactGenerator {
        final ProductReleaseArtifact release;

        ComponentSelect(String path, ProductReleaseArtifact release) {
            super(path);
            this.release = release;
            if (release == null) {
                throw new NullPointerException();
            }
        }

        @Override
        Collection<File> assemble_(EBuild ebuild) throws EBuildException {
            return CollectionUtil.singletonList(this.release.artifactFile);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ModuleSelectionInstance
    extends ArtifactGenerator {
        final Collection<File> artifacts;

        public ModuleSelectionInstance(String path, Collection<File> artifacts) {
            super(path);
            this.artifacts = artifacts;
        }

        @Override
        Collection<File> assemble_(EBuild ebuild) {
            return this.artifacts;
        }
    }
}

