/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.core.Artifact;
import ebuild.core.BuildProject;
import ebuild.core.ElementC;
import ebuild.core.Product;
import ebuild.core.ProductBuildProject;
import ebuild.core.ProductDeps;
import ebuild.core.ProductReleaseArtifact;
import ebuild.core.WorkspaceElementProject;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.ConfKey;
import ebuild.xml.PrdXml;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductC
extends ElementC<Product, Artifact.Product> {
    private ProductDeps dependencies;

    public ProductC(Product product, ConfKey subKey, ConfMap confSelected) {
        super(product, subKey, confSelected);
    }

    public Product getProduct() {
        return (Product)this.element;
    }

    @Override
    public BuildProject newBuildProject() {
        return new ProductBuildProject(this);
    }

    @Override
    public WorkspaceElementProject newEclipseProject() {
        return new WorkspaceElementProject(this){};
    }

    @Override
    public ProductDeps getDependencies(Scope scope) {
        return this.dependencies;
    }

    @Override
    public ProductReleaseArtifact getRelease(String artifact) {
        return (ProductReleaseArtifact)this.getReleases().get(artifact);
    }

    public ProductDeps getDependencies() {
        return this.getDependencies(Scope.MAIN);
    }

    public void setDependencies(ProductDeps dependencies) {
        this.dependencies = dependencies;
    }

    public String getReleaseFileName(String artifact) {
        return ((Product)this.element).getMETA().getArtifactName(this.key.ekey.version, artifact, this.getConfigurationSelected());
    }

    @Override
    public File getReleaseFile() {
        return this.getRelease((String)((Product)this.element).getMETA().getDefaultArtifact()).artifactFile;
    }

    @Override
    public List<ProductReleaseArtifact> listReleases() {
        PrdXml.EbuildProduct meta = (PrdXml.EbuildProduct)this.getProduct().getMETA().expectMainXml();
        ArrayList<ProductReleaseArtifact> r = new ArrayList<ProductReleaseArtifact>(meta.artifacts.size());
        for (PrdXml.Artifact a : meta.artifacts) {
            String filename = ((Product)this.element).getMETA().expectArtifactName(this.key.ekey.version, a.name, this.getConfigurationSelected());
            File file = new File(((Product)this.element).getReleaseDirectory(), filename);
            r.add(new ProductReleaseArtifact(this, a.name, file));
        }
        return r;
    }
}

