/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.util;

import ebuild.util.IOUtil;
import java.io.File;
import java.io.IOException;

public class WorkMarker {
    private final File[] files;
    private final File marker;

    public WorkMarker(File ... fs) {
        this.files = fs;
        this.marker = new File(fs[0].getParent(), String.valueOf(fs[0].getName()) + ".inprogress");
    }

    private boolean fileExists() {
        boolean exists = false;
        File[] fileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.exists()) {
                exists = true;
            }
            ++n2;
        }
        return exists;
    }

    public boolean isComplete() {
        return this.fileExists() && !this.marker.exists();
    }

    public boolean isInProgress() {
        return this.marker.exists();
    }

    public void create() {
        try {
            this.marker.getParentFile().mkdirs();
            IOUtil.stringToFile("", this.marker);
        }
        catch (IOException e) {
            throw new Error("Could not create work marker: " + this.marker + "\n " + e.getMessage());
        }
    }

    public void remove() {
        if (!this.marker.delete()) {
            throw new Error("Could not delete work marker: " + this.marker);
        }
    }
}

