/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import java.util.Collection;

public class StringUtil {
    public static String reverseString(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer(s);
        return buff.reverse().toString();
    }

    public static String lpad(int l, String s, char pad) {
        StringBuffer r = new StringBuffer(l);
        int i = 0;
        while (i < l - s.length()) {
            r.append(pad);
            ++i;
        }
        r.append(s);
        return r.toString();
    }

    public static String lpad(int l, String s) {
        return StringUtil.lpad(l, s, ' ');
    }

    public static String rpad(int l, String s, char pad) {
        StringBuffer r = new StringBuffer(l);
        r.append(s);
        int i = 0;
        while (i < l - s.length()) {
            r.append(pad);
            ++i;
        }
        return r.toString();
    }

    public static String rpad(int l, String s) {
        return StringUtil.rpad(l, s, ' ');
    }

    public static String prefix(String prefix, Collection args) {
        return String.valueOf(prefix) + StringUtil.join(prefix, args.toArray());
    }

    public static String join(String separator, Collection args) {
        return StringUtil.join(separator, args.toArray());
    }

    public static String join(String separator, Object ... args) {
        String[] strs = new String[args.length];
        int i = 0;
        while (i < args.length) {
            strs[i] = args[i] == null ? null : args[i].toString();
            ++i;
        }
        return StringUtil.join(separator, strs);
    }

    public static String join(String separator, String ... strs) {
        int l = 0;
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            l += (s == null ? 4 : s.length()) + 1;
            ++n2;
        }
        StringBuilder r = new StringBuilder(l);
        String[] stringArray2 = strs;
        int n3 = strs.length;
        n = 0;
        while (n < n3) {
            String s = stringArray2[n];
            if (r.length() > 0) {
                r.append(separator);
            }
            r.append(s == null ? "null" : s);
            ++n;
        }
        return r.toString();
    }

    public static String join(String separator, int ... args) {
        StringBuffer r = new StringBuffer();
        int[] nArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (r.length() > 0) {
                r.append(separator);
            }
            r.append(i);
            ++n2;
        }
        return r.toString();
    }

    public static String capitiliseWord(String s) {
        if (s.length() == 0) {
            return s;
        }
        char c = s.charAt(0);
        return String.valueOf(Character.toUpperCase(c)) + s.substring(1);
    }

    public static String camelCaseToSeparated(String s, char separator, boolean capitalise) {
        StringBuilder r = new StringBuilder(s.length() + 2);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (i == 0) {
                c = capitalise ? Character.toUpperCase(c) : Character.toLowerCase(c);
            } else if (Character.isUpperCase(c)) {
                r.append(separator);
                if (!capitalise) {
                    c = Character.toLowerCase(c);
                }
            }
            r.append(c);
            ++i;
        }
        return r.toString();
    }

    public static String camelCaseToDashed(String s) {
        return StringUtil.camelCaseToSeparated(s, '-', false);
    }

    public static String pascalCaseFromDashed(String s) {
        return StringUtil.camelCaseFromDashed(s, true);
    }

    public static String camelCaseFromDashed(String s) {
        return StringUtil.camelCaseFromDashed(s, false);
    }

    public static String camelCaseFromDashed(String s, boolean capitaliseFirst) {
        return StringUtil.camelCaseFromSpaced(s, '-', capitaliseFirst);
    }

    public static String camelCaseFromSpaced(String s, char separator, boolean capitaliseFirst) {
        StringBuilder r = new StringBuilder(s.length());
        boolean capitalise = capitaliseFirst;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == separator) {
                capitalise = true;
            } else {
                if (capitalise) {
                    capitalise = false;
                    c = Character.toUpperCase(c);
                }
                r.append(c);
            }
            ++i;
        }
        return r.toString();
    }

    public static boolean isEmptyString(String s) {
        if (s == null) {
            return true;
        }
        return "".equals(s.trim());
    }

    public static boolean isEmptyString(Object o) {
        if (o == null || o instanceof String) {
            return StringUtil.isEmptyString((String)o);
        }
        return false;
    }

    public static Integer tryParseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String ordinal(int i) {
        int last = i % 10;
        switch (last) {
            case 1: {
                return String.valueOf(i) + "st";
            }
            case 2: {
                return String.valueOf(i) + "nd";
            }
            case 3: {
                return String.valueOf(i) + "rd";
            }
        }
        return String.valueOf(i) + "th";
    }

    public static String uncapFirst(String s) {
        if (s.length() == 0) {
            return s;
        }
        String first = s.substring(0, 1).toLowerCase();
        String rest = s.substring(1);
        return String.valueOf(first) + rest;
    }

    public static String indentWithHeading(String heading, String chars2) {
        String[] ss = chars2.split("\n");
        String indent = StringUtil.lpad(heading.length(), "");
        StringBuilder sb = new StringBuilder(chars2.length() + ss.length * heading.length());
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(s == ss[0] ? heading : indent);
            sb.append(s);
            sb.append("\n");
            ++n2;
        }
        sb.append(indent);
        return sb.toString();
    }

    public static String indent(String chars2, String indent) {
        String[] ss = chars2.split("\n");
        StringBuilder sb = new StringBuilder(chars2.length() + ss.length * indent.length());
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(indent);
            sb.append(s);
            sb.append("\n");
            ++n2;
        }
        sb.append(indent);
        return sb.toString();
    }
}

