/*
 * Decompiled with CFR 0.152.
 */
package ebuild.base;

import ebuild.base.EBuildException;
import ebuild.base.Task;
import ebuild.util.tuple.Pair;
import java.util.ArrayDeque;
import java.util.Deque;

public class Backtrace {
    final Task task;
    final Deque<Line> stack = new ArrayDeque<Line>();

    private static Backtrace get() {
        Task t = Task.get();
        if (t == null) {
            return null;
        }
        return t.backtrace;
    }

    static String modifyMessage(String msg) {
        Backtrace bt = Backtrace.get();
        if (bt == null) {
            return msg;
        }
        String topTrace = Backtrace.get().topTrace();
        return String.valueOf(msg) + topTrace;
    }

    public static void start(String verb, Object key) throws EBuildException {
        Backtrace.get().start_(verb, key, false);
    }

    public static void end(Object key) {
        Backtrace.get().end_(key);
    }

    public static void checkCycle(String verb, Object key) throws EBuildException {
        Backtrace.get().checkCycle_(verb, key);
    }

    Backtrace(Task task) {
        this.task = task;
    }

    private boolean isCycle(Line l) {
        Task t = this.task;
        while (t != null) {
            if (t.backtrace.stack.contains(l)) {
                return true;
            }
            t = t.parent;
        }
        return false;
    }

    private void checkCycle(Line l) throws EBuildException {
        if (this.isCycle(l)) {
            this.stack.push(l);
            try {
                throw EBuildException.newConfProblem("Cycle");
            }
            catch (Throwable throwable) {
                this.stack.pop();
                throw throwable;
            }
        }
    }

    private void checkCycle_(String verb, Object key) throws EBuildException {
        Line l = new Line(verb, key);
        this.checkCycle(l);
    }

    void start_(String verb, Object key, boolean spacer) throws EBuildException {
        Line l = new Line(verb, key);
        this.checkCycle(l);
        this.stack.push(l);
    }

    void end_(Object key) {
        Line r = this.stack.pop();
        assert (r.getKey() == key);
    }

    public String topTrace() {
        StringBuilder r = new StringBuilder();
        for (Line l : this.stack) {
            r.append("\n    " + l.getVerb());
            r.append("\n        " + l.getKey());
        }
        return r.toString();
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        Task t = this.task;
        while (t != null) {
            if (t != this.task) {
                r.append("\n---------------");
            }
            for (Line l : this.stack) {
                r.append("\n    " + l.getVerb());
                r.append("\n        " + l.getKey());
            }
            t = t.parent;
        }
        return r.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Line
    extends Pair<String, Object> {
        public Line(String verb, Object key) {
            super(verb, key);
        }

        public String getVerb() {
            return (String)this.a;
        }

        public Object getKey() {
            return this.b;
        }
    }
}

