/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.plugin.IPropertyMap;
import ebuild.base.EBuildException;
import ebuild.core.Module;
import ebuild.core.conf.ConfMap;
import ebuild.core.conf.ConfMapping;
import ebuild.core.impl.EBuildUtil;
import ebuild.xml.CmnXml;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildPluginDef {
    final Module module;
    final BuildPluginDef prototype;
    final List<CmnXml.Property> props;
    final ConfMapping mapping;

    protected BuildPluginDef(BuildPluginDef prototype, Module module, ConfMapping mapping, List<CmnXml.Property> props) {
        this.prototype = prototype;
        this.module = module;
        this.mapping = mapping;
        this.props = props;
    }

    private void evaluateMapping(ConfMap inputConf, ConfMap.Builder builder) throws EBuildException {
        if (this.prototype != null) {
            this.prototype.evaluateMapping(inputConf, builder);
        }
        this.mapping.evaluate(inputConf, builder);
    }

    protected ConfMap evaluateMapping(ConfMap inputConf) throws EBuildException {
        ConfMap.Builder r = new ConfMap.Builder();
        this.evaluateMapping(inputConf, r);
        return r.build();
    }

    protected void configureProps(IPropertyMap propsC, ConfMap contextConf, ConfMap pluginConf) throws EBuildException {
        if (this.prototype != null) {
            this.prototype.configureProps(propsC, contextConf, pluginConf);
        }
        for (CmnXml.Property p : this.props) {
            if (!EBuildUtil.evaluateExpr(p.conf, contextConf)) continue;
            propsC.put(p.key, p.getValue());
        }
        Map<String, String> cs = pluginConf.asMap();
        for (String k : cs.keySet()) {
            String v = cs.get(k);
            propsC.put("conf." + k, (Object)v);
        }
    }

    public abstract BuildPluginDef clone(ConfMapping var1, List<CmnXml.Property> var2);
}

