/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.BuilderInstance;
import ebuild.util.tuple.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderChain {
    final List<BuilderInstance> builders;

    public BuilderChain(List<BuilderInstance> builders) {
        this.builders = builders;
    }

    public Collection<BuilderInstance> getBuilders() {
        return this.builders;
    }

    public Pair<Collection<BuilderInstance>, Collection<BuilderInstance>> getBuildersForEclipse() {
        ArrayList<BuilderInstance> eclipse = new ArrayList<BuilderInstance>(this.builders.size());
        HashSet<String> requiredInputs = new HashSet<String>();
        for (BuilderInstance bi : this.builders) {
            if (!bi.hasEclipseNature()) continue;
            eclipse.add(bi);
            requiredInputs.addAll(bi.getInputs());
        }
        ArrayList<BuilderInstance> gen = new ArrayList<BuilderInstance>(this.builders.size());
        for (BuilderInstance bi : this.builders) {
            if (Collections.disjoint(requiredInputs, bi.getOutputs()) && bi.hasEclipseNature()) continue;
            gen.add(bi);
        }
        return new Pair<Collection<BuilderInstance>, Collection<BuilderInstance>>(gen, eclipse);
    }
}

