/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IEBuild;
import ebuild.api.common.ElementType;
import ebuild.api.log.ILogger;
import ebuild.api.log.ISwitch;
import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.base.EBuildException;
import ebuild.base.EBuildLogger;
import ebuild.base.PathJanitor;
import ebuild.compat.AbstractCompatability;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.BuildResolutionReport;
import ebuild.core.EBuildContextOfRoot;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ElementMeta;
import ebuild.core.ElementProject;
import ebuild.core.ElementRelease;
import ebuild.core.MetaDir;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.ModuleC;
import ebuild.core.ModuleMeta;
import ebuild.core.ModuleProject;
import ebuild.core.ModuleRelease;
import ebuild.core.Product;
import ebuild.core.ProductBuildPlan;
import ebuild.core.ProductC;
import ebuild.core.ProductMeta;
import ebuild.core.ProductProject;
import ebuild.core.RepositoryInstance;
import ebuild.core.RepositoryProviderInstance;
import ebuild.core.RepositoryRef;
import ebuild.core.RepositoryWorkingCopy;
import ebuild.core.SystemPlugins;
import ebuild.core.WorkspaceProject;
import ebuild.core.impl.KeyC;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.PersistentMap;
import ebuild.core.impl.Version;
import ebuild.repo.http.HttpRepositoryProvider;
import ebuild.util.Callable;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import ebuild.util.JSONUtil;
import ebuild.util.Logger;
import ebuild.util.ObjectUtil;
import ebuild.util.StringUtil;
import ebuild.version.EBuildVersion;
import ebuild.xml.MachineOptionsXml;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBuild
implements IEBuild,
PathJanitor {
    static final List<String> BUILT_IN_REPOS = CollectionUtil.newList("public      |http |http://repo.ebuild-project.org/download/0.7/", "maven-public|maven|named://maven-public", "ivy-roundup |ivy  |named://ivy-roundup");
    public static final Logger ROOT_LOGGER = Logger.newRootLogger();
    public final ClassLoader apiClassLoader;
    public final EBuildContextOfRoot context;
    public final EBuildLogger logger;
    public final EBuildLogger logger_verbose;
    public final Options options;
    public final BuildResolutionReport report;
    public final BuildResolutionReport.Database reportDatabase;
    public final ActionQueue queue = new ActionQueue();
    public final Map<Object, BuildPlan> buildPlans = new LinkedHashMap<Object, BuildPlan>();
    public final SystemPlugins PLUGINS;
    public final Home HOME;
    public final WorkspaceSet WORKSPACES;
    public final Library LIBRARY;
    public final Repos REPOS;
    private MachineOptions machineOptions;
    public boolean updateUpstream = true;
    static final String LIBRARY_MAJOR = "0.8";
    static final int LIBRARY_MINOR = 6;
    private Map props = null;
    final Map<EBuildVersion, AbstractCompatability> compatabilities = new HashMap<EBuildVersion, AbstractCompatability>(2);

    public EBuild(ClassLoader apiClassLoader, Options options) {
        this(apiClassLoader, options, EBuildLogger.newRootLogger(options.debug), true, null);
        System.setProperty("ebuild.verbose", "" + options.verbosity.isVerbose());
        System.setProperty("ebuild.verbosity.one", "" + options.verbosity.isVerbose());
        System.setProperty("ebuild.verbosity.two", "" + options.verbosity.isVeryVerbose());
        System.setProperty("ebuild.debug", "" + options.debug);
    }

    public EBuild(ClassLoader apiClassLoader, Options options, EBuildLogger logger, boolean inferWorkingCopies, SystemPlugins plugins) {
        this.apiClassLoader = apiClassLoader;
        this.options = options;
        this.logger = logger;
        this.logger_verbose = (EBuildLogger)logger.newSubLogger(new ISwitch(){

            public boolean isOn() {
                return EBuild.this.options.verbosity.isVerbose();
            }
        });
        this.REPOS = new Repos(inferWorkingCopies);
        this.HOME = new Home(options.home);
        this.WORKSPACES = new WorkspaceSet(options.getWorkspaces());
        this.LIBRARY = new Library(this.HOME.getFile("library"));
        this.context = new EBuildContextOfRoot(this, "Root");
        this.context.addRepository(new RepositoryRef.NamedRef(this.context, "machine", new RepositoryInstance.Machine()));
        this.addRepos(BUILT_IN_REPOS);
        this.addRepos(options.overrideRepositories);
        RepositoryRef prototype = this.context.getRepository("public");
        RepositoryRef.DerivedRef ebuildRef = new RepositoryRef.DerivedRef(prototype, this.context, "ebuild"){
            final Version api;
            final Version plugins;
            {
                this.api = Version.newTag("0.8.0");
                this.plugins = Version.newTag(EBuild.LIBRARY_MAJOR);
            }

            public Version getDefaultVersion(String org, String name) {
                if (name.startsWith("api")) {
                    return this.api;
                }
                return this.plugins;
            }
        };
        ebuildRef.setMandatoryOrg("ebuild");
        this.context.addRepository(ebuildRef);
        this.context.addLocalRepository(null, null);
        this.context.addRepository(this.newAliasRepositoryRef("ibiblio", "maven-public"));
        this.context.addRepository(this.newAliasRepositoryRef("ivyroundup", "ivy-roundup"));
        this.PLUGINS = plugins == null ? new SystemPlugins(this) : plugins;
        BuildResolutionReport report = EBuild.newReport(logger, this.isVerbose());
        if (options.generateBuildReport != GenerateBuildReport.no) {
            this.reportDatabase = new BuildResolutionReport.Database();
            report = new BuildResolutionReport.Tee(report, this.reportDatabase);
        } else {
            this.reportDatabase = null;
        }
        this.report = report;
    }

    public static BuildResolutionReport newReport(ILogger logger, boolean verbose) {
        if (verbose) {
            return new BuildResolutionReport.Verbose(logger);
        }
        return new BuildResolutionReport.Terse(logger);
    }

    private MachineOptions readMachineOptions(File f) throws EBuildException {
        if (f.isFile()) {
            try {
                MachineOptionsXml.EBuildMachineOptions r = MachineOptionsXml.deserialize(f);
                this.logger.log("*machine specific options: " + this.formatAsDisplayPath(f));
                return new MachineOptions(f, r);
            }
            catch (Exception e) {
                throw EBuildException.newConfProblem("Unable to read: " + this.formatAsDisplayPath(f), e);
            }
        }
        return null;
    }

    public List<File> getMachineOptionsLocations() {
        File dotEbuild = new File(System.getProperty("user.home"), ".ebuild");
        return CollectionUtil.newList(FileUtil.canonicalFile(this.HOME.getFile("machine-options.xml")), new File(dotEbuild, "0.8/machine-options.xml"), new File(dotEbuild, "machine-options.xml"));
    }

    public MachineOptions getMachineOptions() throws EBuildException {
        for (File f : this.getMachineOptionsLocations()) {
            this.machineOptions = this.readMachineOptions(f);
            if (this.machineOptions != null) break;
        }
        if (this.machineOptions == null) {
            MachineOptionsXml.EBuildMachineOptions xml = new MachineOptionsXml.EBuildMachineOptions();
            xml.modules = CollectionUtil.EMPTY_LIST;
            this.machineOptions = new MachineOptions(null, xml);
        }
        return this.machineOptions;
    }

    private void addRepos(List<String> repos) {
        for (String value : repos) {
            String[] name_type_url = value.split("\\|", 3);
            if (name_type_url.length != 3) {
                throw new Error("Expected repos to be specified <name>|<type>|<url");
            }
            String name = name_type_url[0].trim();
            String type = this.getSettingProp("repo.type-" + name, name_type_url[1].trim());
            String url = this.getSettingProp("repo.url-" + name, name_type_url[2].trim());
            this.context.addRepository(this.newLazyRepositoryRef(name, type, url));
        }
    }

    private RepositoryRef newLazyRepositoryRef(String name, final String type, final String uri) {
        String universe = "http".equals(type) ? "release" : type;
        return new RepositoryRef.LazyRef(this.context, name, universe, new Callable<RepositoryInstance, EBuildException>(){

            @Override
            public RepositoryInstance run() throws EBuildException {
                return EBuild.this.REPOS.getRepository(type, uri);
            }
        });
    }

    private RepositoryRef newAliasRepositoryRef(String name, String aliasedName) {
        RepositoryRef prototype = this.context.getRepository(aliasedName);
        return new RepositoryRef.DerivedRef(prototype, this.context, name);
    }

    public void log(String msg) {
        this.logger.log(msg);
    }

    public boolean isVerbose() {
        return this.options.verbosity.isVerbose();
    }

    public boolean isDEBUG() {
        return this.options.debug;
    }

    public String getPathInWorkspace(File f) {
        return this.WORKSPACES.getPathInWorkspace(f);
    }

    @Override
    public String formatAsDisplayPath(File f) {
        return this.WORKSPACES.formatAsDisplayPath(f);
    }

    public File getCredentialsFile(String path) {
        return this.HOME.getFile("credentials/" + path);
    }

    private Map readPropFile(File f) {
        if (f.exists()) {
            try {
                return JSONUtil.readMap(IOUtil.fileToString(f));
            }
            catch (Exception e) {
                this.logger.log("[WARNING] Unable to load property file: " + this.formatAsDisplayPath(f));
                this.logger.log(e.getMessage());
            }
        }
        return CollectionUtil.EMPTY_MAP;
    }

    private Map loadProps() {
        if (this.props == null) {
            HashMap m = new HashMap();
            m.putAll(this.readPropFile(this.HOME.getFile("seed/settings/properties.json")));
            m.putAll(this.readPropFile(this.HOME.getFile("settings/properties.json")));
            this.props = m;
        }
        return this.props;
    }

    public String getSettingProp(String name, String default_) {
        String r = this.getSettingProp(name);
        if (r == null) {
            return default_;
        }
        return r;
    }

    public String getSettingProp(String name) {
        Object v = this.loadProps().get(name);
        try {
            return (String)v;
        }
        catch (ClassCastException classCastException) {
            this.logger.log("[WARNING] Unexpected value for prop '" + name + "': " + v);
            return null;
        }
    }

    public AbstractCompatability getCompatability(EBuildVersion v) throws EBuildException {
        AbstractCompatability r = this.compatabilities.get((Object)v);
        if (r == null) {
            r = this.PLUGINS.useCompatability(v);
            this.compatabilities.put(v, r);
        }
        return r;
    }

    public String getWorkspaceHeadRevision(RepositoryInstance.Source repo) throws EBuildException {
        String lookup = repo.getUri();
        String r = this.LIBRARY.WORKSPACE_REVISIONS.get(lookup);
        EBuildException rpe = null;
        try {
            if (r == null || this.updateUpstream) {
                String r2 = repo.getRevisionOfHead();
                if (!r2.equals(r)) {
                    this.LIBRARY.WORKSPACE_REVISIONS.putAndUpdate(lookup, r);
                }
                r = r2;
            }
        }
        catch (EBuildException e) {
            rpe = e;
        }
        if (r == null) {
            throw rpe;
        }
        return r;
    }

    public BuildPlan newBuildPlan(ElementC elementC) {
        switch (((Element)elementC.element).key.type) {
            case module: {
                return new ModuleBuildPlan(this, (ModuleC)elementC);
            }
            case product: {
                if (((Element)elementC.element).isSource()) {
                    return new ProductBuildPlan.BuildSource(this, (ProductC)elementC);
                }
                return new ProductBuildPlan.FetchRelease(this, (ProductC)elementC);
            }
        }
        throw new Error("!");
    }

    public BuildPlan getBuildPlan(ElementC elementC) {
        KeyC key = elementC.key;
        BuildPlan r = this.buildPlans.get(key);
        if (r == null) {
            r = this.newBuildPlan(elementC);
            this.buildPlans.put(elementC, r);
            this.report.configure(key.ekey, elementC.getConfigurationSelected());
        }
        return r;
    }

    private ElementProject newElementProject(KeyE key, ElementMeta meta, File projectDir) throws EBuildException {
        if (!meta.isSource()) {
            return null;
        }
        switch (key.type) {
            case product: {
                return new ProductProject(meta.getMetaDir().PRODUCT_BUILD, projectDir);
            }
            case module: {
                return new ModuleProject(meta.getMetaDir().MODULE_BUILD, projectDir);
            }
        }
        throw new Error("!");
    }

    public Element newElement(KeyE key, ElementMeta meta, File projectDir, File releaseDir, File buildDir) throws EBuildException {
        ElementProject elementProject = this.newElementProject(key, meta, projectDir);
        return this.newElementInner(key, meta, elementProject, releaseDir, buildDir);
    }

    private Element newElementInner(KeyE key, ElementMeta meta, ElementProject elementProject, File releaseDir, File buildDir) throws EBuildException {
        switch (key.type) {
            case product: {
                return new Product(this, key, (ProductMeta)meta, (ProductProject)elementProject, new ElementRelease(releaseDir, buildDir));
            }
            case module: {
                return new Module(this, key, (ModuleMeta)meta, (ModuleProject)elementProject, new ModuleRelease(releaseDir, buildDir));
            }
        }
        throw new Error("!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GenerateBuildReport {
        no,
        yes;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Home {
        private final File homeDir;
        private RepositoryWorkingCopy workspaceWorkingCopy;

        Home(File homeDir) {
            this.homeDir = homeDir;
        }

        public RepositoryWorkingCopy getWorkspaceWorkingCopy() throws EBuildException {
            if (this.workspaceWorkingCopy == null) {
                this.workspaceWorkingCopy = EBuild.this.WORKSPACES.createWorkspaceWorkingCopy(this.homeDir);
            }
            return this.workspaceWorkingCopy;
        }

        public File getFile(String name) {
            return FileUtil.canonicalFile(new File(this.homeDir, name));
        }

        public File getPossiblyRelativeFile(File f) {
            if (!f.isAbsolute()) {
                return this.getFile(f.getPath());
            }
            return f;
        }

        public Map<String, String> getWorkspaceConf() {
            File f = this.getFile("workspace.conf");
            if (!f.exists()) {
                return CollectionUtil.EMPTY_MAP;
            }
            try {
                return JSONUtil.readMap(new FileReader(f));
            }
            catch (Exception e) {
                EBuild.this.logger.log("Unable to parse: " + EBuild.this.formatAsDisplayPath(f));
                EBuild.this.logger.log(e);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeepIntermediates {
        never,
        workspace,
        always;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Library {
        public final File root;
        public final File meta;
        public final Set<File> used = new HashSet<File>();
        final File versionFile;
        private final Map<KeyE, Element> elements = new HashMap<KeyE, Element>();
        private final Map<KeyE, ElementMeta> metas = new HashMap<KeyE, ElementMeta>();
        final PersistentMap WORKSPACE_REVISIONS;
        final PersistentMap BRANCH_STARTS;

        private String checkValidity() {
            if (!this.versionFile.isFile()) {
                return "_version file missing";
            }
            String versionStr = IOUtil.fileToStringOrError(this.versionFile);
            try {
                Map m = JSONUtil.readMap(versionStr);
                String major = (String)m.get("major");
                if (!EBuild.LIBRARY_MAJOR.equals(major)) {
                    return "incompatible library version, expected '0.8' got '" + major + "'";
                }
                long minor = (Long)m.get("minor");
                if (minor < 6L) {
                    return "incompatible library minor version, expected '0.8.6' got '0.8." + minor + "'";
                }
            }
            catch (Exception exception) {
                return "invalid version stamp on library: " + versionStr;
            }
            return null;
        }

        public Library(File root) {
            String invalidBecause;
            this.root = root;
            this.meta = new File(root, "_meta");
            this.versionFile = new File(this.meta, "_version");
            if (root.isDirectory() && (invalidBecause = this.checkValidity()) != null) {
                EBuild.this.logger.warn("Deleting library because: " + invalidBecause);
                FileUtil.deleteDirOrError(this.meta);
                FileUtil.deleteDirOrError(root);
            }
            if (!root.isDirectory()) {
                EBuild.this.logger.log("Creating library: " + FileUtil.canonicalFile(root));
                FileUtil.mkdirOrError(this.meta);
                Map m = CollectionUtil.newMap("major", EBuild.LIBRARY_MAJOR, "minor", 6);
                JSONUtil.writeObjectOrError(this.versionFile, m);
            }
            this.WORKSPACE_REVISIONS = new PersistentMap(new File(this.meta, "workspace.revisions"));
            this.BRANCH_STARTS = new PersistentMap(new File(this.meta, "branchstart.revisions"));
        }

        public ElementMeta resolveMeta(RepositoryInstance repoContext, KeyE key) throws EBuildException {
            ElementMeta r = this.metas.get(key);
            if (r == null) {
                MetaDir.Element ro;
                r = repoContext.resolveMeta(EBuild.this, key);
                this.metas.put(key, r);
                ElementType other = MetaDir.other(r.getElementType());
                if (r.getMetaDir() != null && (ro = r.getMetaDir().getElementMeta(other)) != null) {
                    r.getMetaDir().init(other);
                    this.metas.put(key.withType(other), ro);
                }
            }
            return r;
        }

        public Element resolveElement(RepositoryRef repoRef, KeyE key) throws EBuildException {
            assert (!"workspace".equals(key.version.getRevision()));
            assert (!"working".equals(key.version.getRevision()));
            Element r = this.elements.get(key);
            if (r == null) {
                r = this.resolveElementInner(repoRef, key);
                r.setRepository(repoRef.getRepo());
                this.elements.put(key, r);
            }
            return r;
        }

        private Element resolveElementInner(RepositoryRef repoRef, KeyE key0) throws EBuildException {
            KeyE key = key0;
            File dir4version = key.getSubDirectoryOfLibrary(this.root);
            this.used.add(dir4version);
            if (dir4version.isFile()) {
                String revision = IOUtil.fileToStringOrError(dir4version);
                KeyE key2 = key.withRevision(revision);
                return this.resolveElement(repoRef, key2);
            }
            RepositoryInstance repoContext = repoRef.getRepo();
            ElementMeta meta = this.resolveMeta(repoContext, key);
            if (key.type == null) {
                key = key.withType(meta.getElementType());
            }
            Version version = key.version;
            File releaseDir = new File(dir4version, "release");
            if (meta.isSource()) {
                boolean source_level;
                MetaDir metaDir = meta.getMetaDir();
                File buildDir = new File(dir4version, "build");
                File projectDir = new File(dir4version, "project");
                if (!dir4version.exists()) {
                    if (!version.isTag()) {
                        RepositoryInstance.Source srepo = repoContext.asSource();
                        String selectedRevision = key.version.getRevision();
                        String releaseRevision = metaDir.getReleaseRevision(key, repoContext);
                        int rCs = srepo.compareRevisions(releaseRevision, selectedRevision);
                        if (rCs < 0) {
                            IOUtil.stringToFileOrError(releaseRevision, dir4version);
                            KeyE key2 = key.withRevision(releaseRevision);
                            return this.resolveElement(repoRef, key2);
                        }
                    }
                    FileUtil.mkdirOrError(dir4version);
                }
                if (!(source_level = metaDir.dir.getParentFile().equals(dir4version))) {
                    if (!projectDir.isFile()) {
                        FileUtil.mkdirOrError(dir4version);
                        IOUtil.stringToFileOrError(metaDir.projectRevision, projectDir);
                    }
                    projectDir = new File(metaDir.dir.getParentFile(), "project");
                }
                assert (dir4version.isDirectory());
                assert (!projectDir.isFile());
                return EBuild.this.newElement(key, meta, projectDir, releaseDir, buildDir);
            }
            return EBuild.this.newElement(key, meta, null, releaseDir, null);
        }

        public Collection<Element> getResolvedElements() {
            return this.elements.values();
        }
    }

    public class MachineOptions {
        final File file;
        final MachineOptionsXml.EBuildMachineOptions xml;

        public MachineOptions(File file, MachineOptionsXml.EBuildMachineOptions xml) {
            this.file = file;
            this.xml = xml;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Options
    implements Cloneable {
        public boolean noSkipping = false;
        public Verbosity verbosity = Verbosity.normal;
        public boolean debug = false;
        public File home = new File("../_ebuild");
        public List<File> workspaces;
        public List<String> overrideRepositories = CollectionUtil.EMPTY_LIST;
        public KeepIntermediates keepIntermediates = KeepIntermediates.workspace;
        public GenerateBuildReport generateBuildReport = GenerateBuildReport.yes;

        public boolean keepIntermediates(boolean workspace) {
            if (this.keepIntermediates == KeepIntermediates.always) {
                return true;
            }
            return this.keepIntermediates == KeepIntermediates.workspace && workspace;
        }

        public List<File> getWorkspaces() {
            if (this.workspaces == null) {
                return CollectionUtil.newList(new File(this.home, ".."));
            }
            return this.workspaces;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }
    }

    public class Repos {
        private final boolean inferWorkingCopies;
        private final Map<String, RepositoryProviderInstance> providers = new HashMap<String, RepositoryProviderInstance>();

        public Repos(boolean inferWorkingCopies) {
            this.inferWorkingCopies = inferWorkingCopies;
            this.addProviderPlugin("http", new HttpRepositoryProvider());
        }

        public RepositoryProviderInstance addProviderPlugin(String repoType, AbstractRepositoryProvider provider) {
            RepositoryProviderInstance r = new RepositoryProviderInstance(EBuild.this, provider);
            this.providers.put(repoType, r);
            return r;
        }

        public RepositoryProviderInstance expectRepoProvider(String repoType) throws EBuildException {
            RepositoryProviderInstance r = this.providers.get(repoType);
            if (r == null) {
                r = this.addProviderPlugin(repoType, EBuild.this.PLUGINS.useRepoProvider(repoType));
                this.providers.put(repoType, r);
            }
            return r;
        }

        public String inferRepositoryType(File dir) {
            if (!this.inferWorkingCopies) {
                return null;
            }
            if (new File(dir, ".svn").isDirectory()) {
                return "svn";
            }
            if (new File(dir, ".mockvcs").isFile()) {
                return "mockvcs";
            }
            return null;
        }

        public RepositoryInstance getRepository(String repositoryType, String repositoryUrl) throws EBuildException {
            RepositoryProviderInstance prov = this.expectRepoProvider(repositoryType);
            try {
                return prov.getRepository(repositoryUrl);
            }
            catch (RepositoryPluginException e) {
                throw EBuildException.wrapPluginException("Could not creat repository '" + repositoryUrl + "'", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Verbosity {
        normal,
        one,
        two;


        public boolean isVerbose() {
            return this != normal;
        }

        public boolean isVeryVerbose() {
            return this == two;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WorkspaceSet {
        private final Workspace top;
        private final Map<String, WorkspaceProject> projects = new HashMap<String, WorkspaceProject>();

        public WorkspaceSet(List<File> workspaces) {
            Workspace workspace = null;
            for (File f : EBuild.this.options.getWorkspaces()) {
                workspace = new Workspace(workspace, FileUtil.canonicalFile(f));
            }
            this.top = workspace;
        }

        public int getWorkspaceCount() {
            return this.top.number + 1;
        }

        public String getPathInWorkspace(File f) {
            f = FileUtil.canonicalFile(f);
            String fpath = f.getPath();
            return this.top.getPathInWorkspace(fpath);
        }

        public String formatAsDisplayPath(File f) {
            f = FileUtil.canonicalFile(f);
            String fpath = f.getPath();
            return this.top.formatAsDisplayPath(fpath);
        }

        public List<File> getCandidateProjectDirs(String projectName) {
            ArrayList<File> r = new ArrayList<File>(this.getWorkspaceCount());
            this.top.getCandidateProjectDirs(r, projectName);
            return r;
        }

        public Collection<Element> getResolvedElements() {
            ArrayList<Element> r = new ArrayList<Element>(this.projects.size());
            for (WorkspaceProject wsp : this.projects.values()) {
                if (wsp.hasModule()) {
                    r.add(wsp.getModule());
                }
                if (!wsp.hasProduct()) continue;
                r.add(wsp.getProduct());
            }
            return r;
        }

        public WorkspaceProject getWorkspaceProject(KeyE dkey) throws EBuildException {
            WorkspaceProject r = this.getWorkspaceProject(dkey.getDefaultWorkspaceName());
            if (r == null) {
                return null;
            }
            if (!ObjectUtil.areEqual(r.getKey((ElementType)dkey.type).version.getBranchNoDefault(), dkey.version.getBranchNoDefault())) {
                return null;
            }
            return r;
        }

        public WorkspaceProject getWorkspaceProject(String projectName) throws EBuildException {
            if (projectName.startsWith(".")) {
                return null;
            }
            if (projectName.indexOf(45) == -1) {
                return null;
            }
            WorkspaceProject r = this.projects.get(projectName);
            if (r == null) {
                List<File> fs = this.getCandidateProjectDirs(projectName);
                if (fs.size() == 0) {
                    return null;
                }
                r = this.createWorkspaceProject(fs.get(0));
                this.projects.put(projectName, r);
            }
            return r;
        }

        public RepositoryWorkingCopy createWorkspaceWorkingCopy(File dir) throws EBuildException {
            String type = EBuild.this.REPOS.inferRepositoryType(dir);
            AbstractWorkingCopy wc = null;
            RepositoryInstance.Project repo = null;
            if (type != null) {
                try {
                    RepositoryProviderInstance prov = EBuild.this.REPOS.expectRepoProvider(type);
                    wc = prov.provider.getWorkingCopy(dir);
                    repo = null;
                    if (wc != null) {
                        repo = (RepositoryInstance.Source)prov.getRepository(wc.getRepository().getUri());
                    }
                }
                catch (RepositoryPluginException e) {
                    throw EBuildException.wrapPluginException("Could not infer source control for dir '" + this.formatAsDisplayPath(dir) + "'", e);
                }
            }
            if (repo == null) {
                repo = RepositoryInstance.NOREPO;
            }
            return new RepositoryWorkingCopy(wc, repo);
        }

        private WorkspaceProject createWorkspaceProject(File dir) throws EBuildException {
            return new WorkspaceProject(EBuild.this, dir, this.createWorkspaceWorkingCopy(dir));
        }

        public String toString() {
            StringBuilder r = new StringBuilder();
            try {
                TreeMap<String, WorkspaceProject> tm = new TreeMap<String, WorkspaceProject>(this.projects);
                r.append("WorkspaceSet:");
                r.append(StringUtil.prefix("\n    ", tm.keySet()));
                return r.toString();
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.close();
                return sw.toString();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Workspace {
            private final Workspace previous;
            private final int number;
            private final File dir;

            Workspace(Workspace previous, File dir) {
                this.previous = previous;
                this.dir = dir;
                this.number = previous == null ? 0 : previous.number + 1;
            }

            private String formatAsDisplayPath(String fpath) {
                String wpath = this.dir.getPath();
                String n = "" + (WorkspaceSet.this.getWorkspaceCount() == 1 ? "" : Integer.valueOf(this.number));
                String name = "[workspace" + n + "]";
                if (fpath.startsWith(wpath)) {
                    return String.valueOf(name) + fpath.substring(wpath.length());
                }
                if (this.previous == null) {
                    return fpath;
                }
                return this.previous.formatAsDisplayPath(fpath);
            }

            private String getPathInWorkspace(String fpath) {
                String wpath = this.dir.getPath();
                if (fpath.startsWith(wpath)) {
                    return fpath.substring(wpath.length());
                }
                if (this.previous == null) {
                    return null;
                }
                return this.previous.getPathInWorkspace(fpath);
            }

            private void getCandidateProjectDirs(List<File> r, String projectName) {
                File projectDir = new File(this.dir, projectName);
                if (projectDir.isDirectory()) {
                    r.add(projectDir);
                }
                if (this.previous != null) {
                    this.previous.getCandidateProjectDirs(r, projectName);
                }
            }
        }
    }
}

