/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.base.EBuildException;
import ebuild.core.ElementBuildMeta;
import ebuild.util.FileUtil;
import java.io.File;

public class ElementProject {
    public final File dir;
    public final ElementBuildMeta META;
    private Long lastModified = null;

    public ElementProject(ElementBuildMeta META, File dir) {
        this.META = META;
        this.dir = dir;
        assert (!dir.isFile());
    }

    public File getFile(String path) {
        return new File(this.dir, path);
    }

    public long lastModification() throws EBuildException {
        if (this.lastModified == null) {
            long r = Long.MIN_VALUE;
            if (this.dir.isDirectory()) {
                File[] fs;
                File[] fileArray = fs = this.dir.listFiles();
                int n = fs.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.getName().startsWith("src")) {
                        r = Math.max(r, FileUtil.deepLastModified(f));
                    }
                    ++n2;
                }
            } else {
                r = Long.MAX_VALUE;
            }
            this.lastModified = r;
        }
        return this.lastModified;
    }
}

