/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.AbstractBuilder;
import ebuild.base.BuildPluginType;
import ebuild.base.EBuildException;
import ebuild.base.EBuildLogger;
import ebuild.core.Artifact;
import ebuild.core.BuilderChain;
import ebuild.core.BuilderDef;
import ebuild.core.BuilderInstance;
import ebuild.core.EBuild;
import ebuild.core.EBuildContextOfXml;
import ebuild.core.ElementC;
import ebuild.core.Module;
import ebuild.core.ModuleBuildProject;
import ebuild.core.ModuleDeps;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.ModuleWorkspaceProject;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.Exclude;
import ebuild.util.CollectionUtil;
import ebuild.xml.ModXml;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleC
extends ElementC<Module, Artifact.Module> {
    private static final Object FAILED_PLUGIN_INSTANTIATION = new Object();
    private final EBuild ebuild;
    private BuilderChain buildChain;
    private Map<Scope, ModuleDeps> dependenciesMap = new HashMap<Scope, ModuleDeps>();
    private Object pluginInstance;
    public static final Exclude NOAPI = Exclude.newExclude(new Exclude.Rule("ebuild", "api.*", null, null, null), new Exclude.Rule("ebuild", "compat", null, null, null));

    public ModuleC(Module module, ConfKey subKey, ConfMap configurationSelected) {
        super(module, subKey, configurationSelected);
        this.ebuild = module.ebuild;
    }

    public Module getModule() {
        return (Module)this.element;
    }

    @Override
    public Artifact.Module getRelease(String artifact) {
        return (Artifact.Module)super.getRelease(artifact);
    }

    @Override
    public ModuleBuildProject newBuildProject() {
        return new ModuleBuildProject(this);
    }

    @Override
    public ModuleWorkspaceProject newEclipseProject() {
        return new ModuleWorkspaceProject(this);
    }

    @Override
    public ModuleWorkspaceProject getWorkspaceProject() {
        return (ModuleWorkspaceProject)this.eclipse;
    }

    private Artifact.Module newRelease(String artifact) {
        String filepart = artifact;
        if ("java_classes.jar".equals(artifact) && this.is0_7()) {
            filepart = "java.classes.jar";
        }
        return ((Module)this.element).getMETA().newModuleRelease(this, artifact, filepart, Scope.MAIN, this.getReleaseDirectory());
    }

    @Override
    public File getReleaseFile() {
        return this.getReleaseDirectory();
    }

    public File getReleaseDirectory() {
        return new File(((Module)this.getPart()).getReleaseDirectory(), this.getConfiguration().asDirectoryName());
    }

    @Override
    public List<Artifact.Module> listReleases() {
        ModuleC moduleC1 = this.getCompiled();
        if (this != moduleC1) {
            return moduleC1.listReleases();
        }
        if (this.is0_7()) {
            return CollectionUtil.newList(this.newRelease("java_classes.jar"));
        }
        ModXml.EbuildModule meta = this.getModule().getMETA().expectMainXml();
        ArrayList<Artifact.Module> r = new ArrayList<Artifact.Module>(meta.artifacts.size());
        for (ModXml.Artifact a : meta.artifacts) {
            r.add(this.newRelease(a.name));
        }
        return r;
    }

    public BuilderChain getBuildChain() {
        return this.buildChain;
    }

    @Override
    public ModuleDeps getDependencies(Scope scope) {
        return this.dependenciesMap.get(scope);
    }

    public ModuleDeps expectDependencies(Scope scope) {
        ModuleDeps r = this.getDependencies(scope);
        if (r == null) {
            throw new Error("Depedencies not initialised " + scope + " for " + this);
        }
        return r;
    }

    public void setDependencies(Scope scope, ModuleDeps deps) {
        assert (!this.dependenciesMap.containsKey(scope));
        this.dependenciesMap.put(scope, deps);
    }

    public AbstractAssembler asAssembler() throws EBuildException {
        return (AbstractAssembler)this.instantiatePlugin();
    }

    public AbstractBuilder asBuilder() throws EBuildException {
        return (AbstractBuilder)this.instantiatePlugin();
    }

    public BuilderChain configureAndParameterizeBuilderChain() throws EBuildException {
        ModuleProjectHelper phelper = ((Module)this.element).getProjectHelper();
        EBuildContextOfXml bcontext = phelper.contextOfBuild;
        Map<Object, ? extends ModXml.Builder> builderXmls = this.getModule().getProject().getMETA().getBuildDependencies(this.getSubKey());
        ArrayList<BuilderInstance> builders = new ArrayList<BuilderInstance>(builderXmls.size());
        for (Object localKey : builderXmls.keySet()) {
            BuilderInstance builderInstance;
            BuilderDef builderDef = (BuilderDef)bcontext.expectBuildPluginDefByLocalKey(localKey);
            if (builderDef.signature.inputs == null) {
                HashSet<String> inputs = new HashSet<String>();
                for (BuilderInstance previous : builders) {
                    inputs.addAll(previous.signature.outputs);
                }
                builderInstance = builderDef.instantiate(this.getConfiguration(), inputs);
            } else {
                builderInstance = builderDef.instantiate(this.getConfiguration());
            }
            builders.add(builderInstance);
        }
        this.buildChain = new BuilderChain(builders);
        return this.buildChain;
    }

    public boolean isIntermediate(String artifactType) {
        return !this.getReleases().keySet().contains(artifactType);
    }

    @Override
    public ModuleC getCompiled() {
        Module m;
        if (this instanceof ModuleC && (m = (Module)this.element).isPlugin()) {
            return (ModuleC)m.getDefault();
        }
        return this;
    }

    public Object instantiatePluginInner() throws EBuildException {
        if (this.pluginInstance == null) {
            try {
                this.pluginInstance = this.instantiateBuildPlugin();
            }
            catch (Throwable e) {
                this.pluginInstance = FAILED_PLUGIN_INSTANTIATION;
                throw EBuildException.newPluginProblem("Unable to register plugin: " + this.key, e);
            }
        }
        if (this.pluginInstance == FAILED_PLUGIN_INSTANTIATION) {
            throw EBuildException.newPluginProblem("Broken plugin: " + this.key);
        }
        return this.pluginInstance;
    }

    public Object instantiatePlugin() throws EBuildException {
        return this.getCompiled().instantiatePluginInner();
    }

    public void registerRelease() throws EBuildException {
        if (((Module)this.element).isPlugin()) {
            try {
                BuildPluginType type = ((Module)this.element).buildPlugin.getType();
                if (type.isSystemPlugin()) {
                    Collection<String> classpath = this.getClassPath(Scope.MAIN);
                    if (classpath.size() == 0) {
                        throw EBuildException.newInternalError("Empty classpath!");
                    }
                    this.ebuild.PLUGINS.registerSystemPlugin(this, classpath);
                }
            }
            catch (Exception e) {
                this.ebuild.logger.warn("Unable to register plugin: " + this.key, e);
            }
        }
    }

    public Object instantiateBuildPlugin() throws EBuildException {
        BuildPluginType type;
        if (((Module)this.element).isPlugin() && !(type = ((Module)this.element).buildPlugin.getType()).isSystemPlugin()) {
            Collection<String> classpath = this.getClassPath(Scope.MAIN);
            if (classpath.size() == 0) {
                throw EBuildException.newInternalError("Empty classpath!");
            }
            return ((Module)this.element).buildPlugin.instantiate(this.ebuild, this.ebuild.apiClassLoader, classpath);
        }
        return null;
    }

    private void logPluginPath(Collection<String> elements) {
        EBuildLogger l = this.ebuild.logger;
        l.log("plugin runtime path for '" + this.key + "': ");
        for (String s : elements) {
            l.log("    " + this.ebuild.formatAsDisplayPath(new File(s)));
        }
    }

    public Collection<String> getClassPath(Scope scope) throws EBuildException {
        Artifact.Module release = this.getRelease("java_classes.jar");
        if (release == null) {
            throw EBuildException.newPluginProblem("Build plugin " + this.key + " does not have a java_classes.jar artifact");
        }
        ModuleDeps mcdeps = this.getDependencies(Scope.MAIN);
        ModuleDeps.GathererOfFiles gatherer = new ModuleDeps.GathererOfFiles(false, "java_classes.jar");
        ModuleDeps.RecurseRule rule = new ModuleDeps.RecurseRule(){

            public boolean ignore(ModuleDeps.ModuleDep md) {
                if (md.subsumed) {
                    return true;
                }
                if (md.loadgroup != null) {
                    return true;
                }
                return NOAPI.match(md.key);
            }
        };
        gatherer.setContinueRule(rule);
        mcdeps.doDeepGather(gatherer, rule, NOAPI);
        gatherer.add(release);
        LinkedHashSet<String> elements = new LinkedHashSet<String>(gatherer.files.size());
        for (File f : gatherer.files) {
            elements.add(f.getAbsolutePath());
        }
        if (this.ebuild.isDEBUG() || this.ebuild.isVerbose()) {
            this.logPluginPath(elements);
        }
        return elements;
    }
}

