/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.api.common.Scope;
import ebuild.core.impl.BuildTask;
import ebuild.util.StringUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTaskSet
implements Iterable<BuildTask> {
    public static BuildTaskSet NONE = new BuildTaskSet(EnumSet.noneOf(BuildTask.class));
    private final EnumSet<BuildTask> tasks;

    public BuildTaskSet(BuildTask task) {
        this(EnumSet.of(task));
    }

    private BuildTaskSet(EnumSet<BuildTask> tasks) {
        this.tasks = tasks;
    }

    public boolean has(BuildTask t) {
        return this.tasks.contains((Object)t);
    }

    public boolean includes(BuildTaskSet ts) {
        return this.tasks.containsAll(ts.tasks);
    }

    public BuildTaskSet combine(BuildTaskSet ts) {
        Object tasks2 = this.tasks.clone();
        ((AbstractCollection)tasks2).addAll(ts.tasks);
        return new BuildTaskSet((EnumSet<BuildTask>)tasks2);
    }

    public BuildTaskSet replace(BuildTask a, BuildTask b) {
        BuildTaskSet r = this;
        if (this.has(a)) {
            r = this.without(a).with(b);
        }
        return r;
    }

    public BuildTaskSet with(BuildTask task) {
        Object tasks2 = this.tasks.clone();
        ((AbstractCollection)tasks2).add(task);
        return new BuildTaskSet((EnumSet<BuildTask>)tasks2);
    }

    public BuildTaskSet without(BuildTask task) {
        if (!this.has(task)) {
            return this;
        }
        Object tasks2 = this.tasks.clone();
        ((AbstractCollection)tasks2).remove((Object)task);
        return new BuildTaskSet((EnumSet<BuildTask>)tasks2);
    }

    public boolean hasIDE() {
        return this.has(BuildTask.eclipse_setup) || this.has(BuildTask.eclipse_unsetup);
    }

    public BuildTaskSet withoutIDE() {
        BuildTaskSet r = this;
        r = r.without(BuildTask.eclipse_setup);
        r = r.without(BuildTask.eclipse_unsetup);
        return r;
    }

    public BuildTaskSet tasksForBuilders() {
        BuildTaskSet r = this;
        if (this.has(BuildTask.eclipse_setup)) {
            r = this.with(BuildTask.build_release);
        }
        if (this.has(BuildTask.eclipse_unsetup)) {
            r = this.with(BuildTask.build_clean);
        }
        return r;
    }

    public Scope getScope() {
        if (this.has(BuildTask.eclipse_setup) || this.has(BuildTask.eclipse_unsetup)) {
            return Scope.POKE;
        }
        return Scope.MAIN;
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    public List<BuildTask> asList() {
        return new ArrayList<BuildTask>(this.tasks);
    }

    @Override
    public Iterator<BuildTask> iterator() {
        return this.tasks.iterator();
    }

    public String toString() {
        return StringUtil.join(",", this.tasks);
    }
}

