/*
 * Decompiled with CFR 0.152.
 */
package ebuild.eclipse;

import ebuild.api.eclipse.IEclipseProject;
import ebuild.core.ModuleWorkspaceProject;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;

public class EclipseProject
implements IEclipseProject {
    private final ModuleWorkspaceProject workspaceProject;
    private final List<String> natures = new ArrayList<String>(2);
    private final List<String> buildCommands = new ArrayList<String>(2);
    private final Settings settings = new Settings();
    private long projectModified;

    public EclipseProject(ModuleWorkspaceProject workspaceProject) {
        this.workspaceProject = workspaceProject;
    }

    public void init() {
        this.projectModified = this.workspaceProject.getProjectFile(".project").lastModified();
    }

    public void commit() throws IOException {
        if (this.projectModified == this.workspaceProject.getProjectFile(".project").lastModified()) {
            this.generateDotProject();
        }
        this.settings.commit();
    }

    public void addNature(String nature) {
        this.natures.add(nature);
    }

    public void addBuildCommand(String builder) {
        this.buildCommands.add(builder);
    }

    public void suggestSetting(String file, String key, String value) throws IOException {
        this.settings.suggest(file, key, value);
    }

    public void setSetting(String file, String key, String value) throws IOException {
        this.settings.set(file, key, value);
    }

    public String getSetting(String file, String key) throws IOException {
        return this.settings.get(file, key);
    }

    public void generateDotProject() throws IOException {
        StringTemplate template = EclipseProject.getTemplate("project");
        template.setAttribute("name", this.workspaceProject.module.getName());
        template.setAttribute("natures", this.natures);
        template.setAttribute("buildCommands", this.buildCommands);
        this.writeFile(".project", template.toString());
    }

    private static StringTemplateGroup getTemplateGroup(String name) throws IOException {
        URL url = EclipseProject.class.getResource(name);
        InputStream is = url.openStream();
        return new StringTemplateGroup((Reader)new InputStreamReader(is), DefaultTemplateLexer.class);
    }

    private static StringTemplate getTemplate(String name) throws IOException {
        return EclipseProject.getTemplateGroup(String.valueOf(name) + ".stg").getInstanceOf(name);
    }

    private void writeFile(String path, String contents) throws IOException {
        IOUtil.stringToFile(contents, this.workspaceProject.getProjectFile(path));
    }

    private class Settings {
        private final Map<String, Properties> settings = new LinkedHashMap<String, Properties>();
        private final Set<String> updated = new HashSet<String>();

        private Settings() {
        }

        private File getSettingsFile(String file) {
            return EclipseProject.this.workspaceProject.getProjectFile(".settings/" + file);
        }

        private Properties load(String file) throws IOException {
            File f = this.getSettingsFile(file);
            Properties props = new Properties();
            if (!f.exists()) {
                props.put("eclipse.preferences.version", "1");
                return props;
            }
            props.load(new FileInputStream(f));
            return props;
        }

        private void store(String file, Properties props) throws IOException {
            File f = this.getSettingsFile(file);
            FileUtil.mkdirOrFail(f.getParentFile());
            props.store(new FileOutputStream(f), "");
        }

        private Properties getSettings(String file) throws IOException {
            Properties r = this.settings.get(file);
            if (r == null) {
                r = this.load(file);
                this.settings.put(file, r);
            }
            return r;
        }

        public void suggest(String file, String key, String value) throws IOException {
            Properties props = this.getSettings(file);
            if (!props.containsKey(key)) {
                this.set(file, key, value);
            }
        }

        public void set(String file, String key, String value) throws IOException {
            this.getSettings(file).setProperty(key, value);
            this.updated.add(file);
        }

        public String get(String file, String key) throws IOException {
            return this.getSettings(file).getProperty(key);
        }

        void commit() throws IOException {
            for (String file : this.updated) {
                this.store(file, this.settings.get(file));
            }
        }
    }
}

