/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Constructor;
import java.util.List;
import org.simpleframework.xml.core.Criteria;
import org.simpleframework.xml.core.Index;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.Variable;

class Builder {
    private final List<Parameter> list;
    private final Constructor factory;
    private final Index index;

    public Builder(Constructor factory, Index index) {
        this.list = index.getParameters();
        this.factory = factory;
        this.index = index;
    }

    public boolean isDefault() {
        return this.index.size() == 0;
    }

    public Parameter getParameter(String name) {
        return (Parameter)this.index.get(name);
    }

    public Object getInstance() throws Exception {
        if (!this.factory.isAccessible()) {
            this.factory.setAccessible(true);
        }
        return this.factory.newInstance(new Object[0]);
    }

    public Object getInstance(Criteria criteria) throws Exception {
        Object[] values = this.list.toArray();
        for (int i = 0; i < this.list.size(); ++i) {
            values[i] = this.getVariable(criteria, i);
        }
        return this.getInstance(values);
    }

    private Object getVariable(Criteria criteria, int index) throws Exception {
        Parameter parameter = this.list.get(index);
        String name = parameter.getName();
        Variable variable = criteria.remove(name);
        if (variable != null) {
            return variable.getValue();
        }
        return null;
    }

    private Object getInstance(Object[] list) throws Exception {
        if (!this.factory.isAccessible()) {
            this.factory.setAccessible(true);
        }
        return this.factory.newInstance(list);
    }

    public int score(Criteria criteria) throws Exception {
        int score = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            Parameter parameter = this.list.get(i);
            String name = parameter.getName();
            Variable label = criteria.get(name);
            if (label == null) {
                if (parameter.isRequired()) {
                    return -1;
                }
                if (parameter.isPrimitive()) {
                    return -1;
                }
            }
            ++score;
        }
        return score;
    }

    public String toString() {
        return this.factory.toString();
    }
}

