/*
 * Decompiled with CFR 0.152.
 */
package ebuild.base;

import ebuild.base.EBuildException;
import ebuild.util.tuple.Pair;
import java.util.ArrayDeque;
import java.util.Deque;

public class Backtrace {
    private static final ThreadLocal<Backtrace> threadLocal = new ThreadLocal();
    final Deque<Line> stack = new ArrayDeque<Line>();

    private static Backtrace get() {
        return threadLocal.get();
    }

    static String modifyMessage(String msg) {
        Backtrace bt = Backtrace.get();
        if (bt == null) {
            return msg;
        }
        String topTrace = Backtrace.get().topTrace();
        return String.valueOf(msg) + topTrace;
    }

    public static void startTop(String verb, Object key) throws EBuildException {
        Backtrace bt = Backtrace.get();
        if (bt == null) {
            bt = new Backtrace();
            threadLocal.set(bt);
        }
        bt.start_(verb, key, true);
    }

    public static void endTop(Object key) {
        Backtrace bt = Backtrace.get();
        bt.end_(key);
        if (bt.stack.size() == 0) {
            threadLocal.set(null);
        }
    }

    public static void start(String verb, Object key) throws EBuildException {
        Backtrace.get().start_(verb, key, false);
    }

    public static void end(Object key) {
        Backtrace.get().end_(key);
    }

    public static void checkCycle(String verb, Object key) throws EBuildException {
        Backtrace.get().checkCycle_(verb, key);
    }

    private Backtrace() {
    }

    private void checkCycle(Line l) throws EBuildException {
        if (this.stack.contains(l)) {
            this.stack.push(l);
            try {
                throw EBuildException.newProblem("Cycle");
            }
            catch (Throwable throwable) {
                this.stack.pop();
                throw throwable;
            }
        }
    }

    private void checkCycle_(String verb, Object key) throws EBuildException {
        Line l = new Line(verb, key, false);
        this.checkCycle(l);
    }

    private void start_(String verb, Object key, boolean spacer) throws EBuildException {
        Line l = new Line(verb, key, spacer);
        this.checkCycle(l);
        this.stack.push(l);
    }

    private void end_(Object key) {
        Line r = this.stack.pop();
        assert (r.getKey() == key);
    }

    public String topTrace() {
        StringBuilder r = new StringBuilder();
        for (Line l : this.stack) {
            r.append("\n    " + l.getVerb());
            r.append("\n        " + l.getKey());
            if (l.spacer) break;
        }
        return r.toString();
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (Line l : this.stack) {
            r.append("\n    " + l.getVerb());
            r.append("\n        " + l.getKey());
            if (!l.spacer) continue;
            r.append("\n---------------");
        }
        return r.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Line
    extends Pair<String, Object> {
        final boolean spacer;

        public Line(String verb, Object key, boolean spacer) {
            super(verb, key);
            this.spacer = spacer;
        }

        public String getVerb() {
            return (String)this.a;
        }

        public Object getKey() {
            return this.b;
        }
    }
}

