/*
 * Decompiled with CFR 0.152.
 */
package ebuild.base;

import ebuild.api.plugin.BuildPluginException;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.base.Backtrace;
import ebuild.util.Logger;

public class EBuildException
extends Exception {
    public final boolean error;

    private EBuildException(String msg, Throwable t, boolean error) {
        super(Backtrace.modifyMessage(String.valueOf(error ? "[EBuild Error]" : "[Conf Problem]") + " " + msg), t);
        this.error = error;
    }

    public static EBuildException wrapPluginException(String msg, RepositoryPluginException e) {
        return EBuildException.newProblem(msg, (Throwable)e);
    }

    public static EBuildException newProblem(String msg) {
        return EBuildException.newProblem(msg, null);
    }

    public static EBuildException newProblem(String msg, Throwable cause) {
        return new EBuildException(msg, cause, false);
    }

    public static EBuildException newError(String msg, Throwable cause) {
        return new EBuildException(msg, cause, true);
    }

    public String toString() {
        return this.getMessage();
    }

    public static void printReport(Logger logger, boolean debug, Throwable t) {
        StackTraceElement[] causedTrace = null;
        while (true) {
            logger.log("" + t);
            Throwable c = t.getCause();
            boolean handled = t instanceof EBuildException || t instanceof RepositoryPluginException || t instanceof BuildPluginException;
            StackTraceElement[] trace = t.getStackTrace();
            if (!handled || debug) {
                if (causedTrace == null) {
                    int i = 0;
                    while (i < trace.length) {
                        logger.log("\tat " + trace[i]);
                        ++i;
                    }
                } else {
                    int m = trace.length - 1;
                    int n = causedTrace.length - 1;
                    while (m >= 0 && n >= 0 && trace[m].equals(causedTrace[n])) {
                        --m;
                        --n;
                    }
                    int framesInCommon = trace.length - 1 - m;
                    int i = 0;
                    while (i <= m) {
                        logger.log("\tat " + trace[i]);
                        ++i;
                    }
                    if (framesInCommon != 0) {
                        logger.log("\t... " + framesInCommon + " more");
                    }
                }
            }
            if (c == null || t == c) break;
            logger.log("... caused by ...");
            t = c;
            causedTrace = trace;
        }
    }
}

