/*
 * Decompiled with CFR 0.152.
 */
package ebuild.compat_0_8;

import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.AbstractBuilder;
import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.base.BuildPluginType;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.base.PathJanitor;
import ebuild.base.PluginUtil;
import ebuild.compat.AbstractCompatability;
import ebuild.compat.BuilderPrototype;
import ebuild.compat.IBuildPlugin;
import ebuild.version.EBuildVersion;
import ebuild.xml.CmnXml;
import ebuild.xml.ModXml;
import ebuild.xml.PrdXml;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.simpleframework.xml.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compatability
extends AbstractCompatability {
    private static Class<? extends CmnXml> getRootClass(MetaType type) {
        switch (type) {
            case MODULE: {
                return ModXml.EbuildModule.class;
            }
            case MODULE_BUILD: {
                return ModXml.EbuildModuleBuild.class;
            }
            case BUILD_PLUGIN: {
                return ModXml.EbuildBuildPlugin.class;
            }
            case PRODUCT: {
                return PrdXml.EbuildProduct.class;
            }
            case PRODUCT_ASSEMBLY: {
                return PrdXml.EbuildProductAssembly.class;
            }
        }
        throw new Error("!" + (Object)((Object)type));
    }

    public CmnXml.EBuildRoot doParseXml(Class<? extends CmnXml> c, InputStream in) throws Exception {
        Serializer serializer = CmnXml.getSerializer();
        CmnXml.EBuildRoot r = (CmnXml.EBuildRoot)((Object)serializer.read(c, (Reader)new InputStreamReader(in)));
        r.setEBuildVersion(EBuildVersion._0_8);
        return r;
    }

    public CmnXml.EBuildRoot doParseXml(MetaType type, InputStream in) throws EBuildException {
        Class<? extends CmnXml> c = Compatability.getRootClass(type);
        try {
            return this.doParseXml(c, in);
        }
        catch (Exception e) {
            throw EBuildException.newProblem("Unable to parse: " + e);
        }
    }

    @Override
    public CmnXml.EBuildRoot parseXml(MetaType type, InputStream in, boolean verbose) throws EBuildException {
        return this.doParseXml(type, in);
    }

    @Override
    public IBuildPlugin getPlugin(File f) throws Exception {
        final ModXml.EbuildBuildPlugin xml = (ModXml.EbuildBuildPlugin)this.doParseXml(ModXml.EbuildBuildPlugin.class, (InputStream)new FileInputStream(f));
        return new IBuildPlugin(){
            private Object instance;

            @Override
            public BuildPluginType getType() {
                if (xml.isAssembler()) {
                    return BuildPluginType.ASSEMBLER;
                }
                if (xml.isBuilder()) {
                    return BuildPluginType.BUILDER;
                }
                if (xml.isRepositoryProvider()) {
                    return BuildPluginType.REPO;
                }
                if (xml.isCompatability()) {
                    return BuildPluginType.COMPAT;
                }
                return null;
            }

            @Override
            public String getPluginClass() {
                BuildPluginType type = this.getType();
                switch (type) {
                    case ASSEMBLER: {
                        return xml.declareAssembler.class_;
                    }
                    case BUILDER: {
                        return xml.declareBuilder.class_;
                    }
                    case REPO: {
                        return xml.declareRepositoryProvider.class_;
                    }
                    case COMPAT: {
                        return xml.declareCompatability.class_;
                    }
                }
                throw new Error("!");
            }

            private Object getInstance() {
                if (this.instance == null) {
                    throw new Error("Not instantiated");
                }
                return this.instance;
            }

            @Override
            public void instantiate(PathJanitor janitor, ClassLoader apiClassLoader, Collection<String> classPath) throws EBuildException {
                ClassLoader moduleCl = PluginUtil.creatPluginClassLoader(this.getType(), apiClassLoader, classPath);
                this.instance = PluginUtil.instantiate(janitor, moduleCl, this.getPluginClass());
            }

            @Override
            public BuilderPrototype asBuilder(Object key) {
                List<ModXml.Input> inputsXml = xml.declareBuilder.inputs;
                List<ModXml.Output> outputsXml = xml.declareBuilder.outputs;
                HashSet<String> inputs = new HashSet<String>(inputsXml.size());
                HashSet<String> outputs = new HashSet<String>(outputsXml.size());
                for (ModXml.Input i : inputsXml) {
                    inputs.add(i.artifact);
                }
                for (ModXml.Output o : outputsXml) {
                    inputs.add(o.artifact);
                }
                return new BuilderPrototype(key, (AbstractBuilder)this.getInstance(), inputs, outputs);
            }

            @Override
            public AbstractAssembler asAssembler() {
                return (AbstractAssembler)this.getInstance();
            }

            @Override
            public AbstractRepositoryProvider asRepositoryProvider() {
                return (AbstractRepositoryProvider)this.getInstance();
            }
        };
    }
}

