/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.IConfiguration;
import ebuild.api.common.IElementKey;
import ebuild.api.log.ILogger;
import ebuild.api.repo.AbstractReleaseRepository;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.core.ActionStatus;
import ebuild.core.BuildProject;
import ebuild.core.EBuildRunner;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ProductC;
import ebuild.core.WorkspaceProject;
import ebuild.core.util.WorkMarker;
import ebuild.util.ObjectUtil;
import ebuild.util.StringUtil;
import java.io.File;

public abstract class Action {
    public final ActionStatus status;
    public final Element element;
    public final ElementC cElement;

    private static ActionStatus marker2status(WorkMarker marker) {
        if (marker.isInProgress()) {
            return ActionStatus.dirty;
        }
        if (marker.isComplete()) {
            return ActionStatus.done;
        }
        return ActionStatus.todo;
    }

    private Action(ActionStatus status, Element element, ElementC cElement) {
        this.status = status;
        this.element = element;
        this.cElement = cElement;
    }

    public Action(WorkMarker marker, Element element, ElementC cElement) {
        this(Action.marker2status(marker), element, cElement);
    }

    public Action(ActionStatus status, ElementC cElement) {
        this(status, (Element)cElement.element, cElement);
    }

    public abstract String getDisplayName();

    public abstract void run_(ILogger var1) throws Exception;

    public void finish(boolean skipped) throws Exception {
    }

    public final void run(ILogger logger) throws Exception {
        this.run_(logger);
        this.finish(false);
    }

    public int hashCode() {
        return ObjectUtil.hashOf(this.element) + ObjectUtil.hashOf(this.cElement);
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Action b = (Action)obj;
        if (!this.element.equals(b.element)) {
            return false;
        }
        return ObjectUtil.areEqual(this.cElement, b.cElement);
    }

    public String format() {
        return String.valueOf(StringUtil.rpad(16, this.getDisplayName())) + " " + this.element.key.toString() + (this.cElement == null ? "" : " " + this.cElement.key.subkey);
    }

    public String toString() {
        return this.format();
    }

    static class BuildClean
    extends Action {
        public BuildClean(ActionStatus status, ElementC cElement) {
            super(status, cElement);
        }

        public String getDisplayName() {
            return "build clean";
        }

        public void run_(ILogger logger) throws Exception {
            this.element.buildClean();
        }
    }

    static class BuildRelease
    extends Action {
        final EBuildRunner runner;

        public BuildRelease(ActionStatus status, ElementC cElement, EBuildRunner runner) {
            super(status, cElement);
            this.runner = runner;
        }

        public String getDisplayName() {
            return "build release";
        }

        public void run_(ILogger logger) throws Exception {
            BuildProject proj = this.cElement.build;
            if (this.status == ActionStatus.dirty) {
                proj.clean();
            }
            proj.build();
        }

        public void finish(boolean skipped) throws Exception {
            this.cElement.registerRelease();
        }
    }

    static class EclipseSetup
    extends Action {
        public EclipseSetup(ActionStatus status, ElementC cElement) {
            super(status, cElement);
        }

        public String getDisplayName() {
            return "eclipse setup";
        }

        public void run_(ILogger logger) throws Exception {
            WorkspaceProject proj = this.cElement.eclipse;
            if (this.status == ActionStatus.dirty) {
                proj.unsetup();
            }
            proj.setup();
        }
    }

    static class EclipseUnsetup
    extends Action {
        public EclipseUnsetup(ActionStatus status, ElementC cElement) {
            super(status, cElement);
        }

        public String getDisplayName() {
            return "eclipse unsetup";
        }

        public void run_(ILogger logger) throws Exception {
            this.cElement.eclipse.unsetup();
        }
    }

    static class FetchArtifacts
    extends Action {
        final WorkMarker marker;

        public FetchArtifacts(ElementC cElement) {
            super(cElement.getWorkMarker(), (Element)cElement.element, cElement);
            this.marker = cElement.getWorkMarker();
        }

        public String getDisplayName() {
            return "fetch artifacts";
        }

        public void run_(ILogger logger) throws Exception {
            this.marker.create();
            AbstractReleaseRepository repo = (AbstractReleaseRepository)this.element.getRepository();
            if (((Element)this.cElement.element).key.type == ElementType.module) {
                File dir = new File(this.cElement.getReleaseDirectory(), "/main");
                repo.fetchModuleRelease(dir, (IElementKey)this.element.key, (IConfiguration)this.cElement.getConfiguration());
            } else {
                String filename = ((ProductC)this.cElement).releaseFileName();
                repo.fetchComponentRelease(this.element.getReleaseDirectory(), (IElementKey)this.element.key, filename);
            }
            this.marker.remove();
        }

        public void finish(boolean skipped) throws Exception {
            this.cElement.registerRelease();
        }
    }

    static class FetchSource
    extends Action {
        final WorkMarker marker;

        public FetchSource(WorkMarker marker, Element element) {
            super(marker, element, null);
            this.marker = marker;
        }

        public String getDisplayName() {
            return "fetch source";
        }

        public void run_(ILogger logger) throws Exception {
            assert (!this.element.isWorkspace());
            this.marker.create();
            logger.log(String.valueOf(this.element.key.fullnameAndVersionAndUniverse()) + " -> fetching source");
            AbstractSourceRepository repo = (AbstractSourceRepository)this.element.getRepository();
            repo.fetchProject(this.element.getProjectDirectory(), (IElementKey)this.element.key);
            this.marker.remove();
        }
    }
}

