/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.Action;
import ebuild.core.ActionQueue;
import ebuild.core.ActionStatus;
import ebuild.core.BuildProject;
import ebuild.core.BuildResolutionReport;
import ebuild.core.BuilderInstance;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildRunner;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ElementDeps;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.ProjectHelper;
import ebuild.core.WorkspaceProject;
import ebuild.core.impl.ArtifactKey;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Task;
import ebuild.core.impl.TaskSet;
import ebuild.core.util.WorkMarker;
import ebuild.util.tuple.Pair;
import ebuild.xml.CmnXml;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class BuildPlan {
    final EBuild ebuild;
    final EBuildRunner runner;
    final BuildResolutionReport report;
    final Object key;
    protected Set<Object> builderPlans = new LinkedHashSet<Object>();
    private boolean resolvedAndConfigured = false;
    private Set<Pair<EKey, EKey>> resolved = new HashSet<Pair<EKey, EKey>>();

    public BuildPlan(EBuildRunner runner, Object key) {
        this.ebuild = runner.ebuild;
        this.runner = runner;
        this.report = runner.report;
        this.key = key;
        runner.buildPlans.put(this.getKey(), this);
    }

    public Object getKey() {
        return this.key;
    }

    protected abstract void resolveBuilders(TaskSet var1) throws EBuildException;

    protected abstract void resolveAndConfigure_(TaskSet var1) throws EBuildException;

    protected abstract void buildActionList_(ActionQueue var1, TaskSet var2) throws Exception;

    private TaskSet buildTasks(TaskSet tasks) {
        if (this instanceof ModuleBuildPlan) {
            return tasks.tasksForBuilders();
        }
        return tasks;
    }

    public void resolveAndConfigure(TaskSet tasks) throws EBuildException {
        if (this.resolvedAndConfigured) {
            return;
        }
        Object key = this.getKey();
        Backtrace.startTop("resolve and configure", key);
        try {
            this.report.startPlan(this, tasks);
            this.resolveAndConfigure_(tasks);
            this.report.startResolveBuilders();
            this.resolveBuilders(tasks);
            this.report.endResolveBuilders();
            TaskSet btasks = this.buildTasks(tasks);
            for (Object subKey : this.builderPlans) {
                ModuleBuildPlan subPlan = (ModuleBuildPlan)this.runner.buildPlans.get(subKey);
                subPlan.resolveAndConfigure(btasks);
            }
            this.report.endPlan();
            this.resolvedAndConfigured = true;
        }
        finally {
            Backtrace.endTop(key);
        }
    }

    public void buildActionList(ActionQueue queue, TaskSet tasks) throws Exception {
        TaskSet btasks = this.buildTasks(tasks);
        for (Object subKey : this.builderPlans) {
            BuildPlan subPlan = this.runner.buildPlans.get(subKey);
            subPlan.buildActionList(queue, btasks);
        }
        this.buildActionList_(queue, tasks);
    }

    protected void buildActionListForPart(ActionQueue queue, ElementC cElement, TaskSet tasks) throws Exception {
        for (Task t : tasks) {
            this.buildActionListForPart(queue, cElement, t);
        }
    }

    protected void buildActionListForPart(ActionQueue queue, ElementC cElement, Task task) throws Exception {
        Object element = cElement.getPart();
        if (!((Element)element).isWorkspace()) {
            if (((Element)element).isSource()) {
                WorkMarker marker = new WorkMarker(((Element)element).getProjectDirectory());
                Action.FetchSource action = new Action.FetchSource(marker, (Element)element);
                queue.add(action);
            } else {
                queue.add(new Action.FetchArtifacts(cElement));
            }
            if (task.isIDE()) {
                throw new Error("Tried to do IDE task on a library element: " + cElement);
            }
            if (task == Task.fetch_source) {
                return;
            }
        }
        switch (task) {
            case build_release: {
                if (!((Element)element).isSource()) break;
                BuildProject bproject = cElement.createBuildProject();
                ActionStatus status = bproject.isDirty(Scope.MAIN) ? ActionStatus.dirty : (bproject.isClean() ? ActionStatus.todo : ActionStatus.done);
                queue.add(new Action.BuildRelease(status, cElement, this.runner));
                break;
            }
            case build_clean: {
                if (!((Element)element).isSource()) break;
                ActionStatus status = ((Element)element).buildIsClean() ? ActionStatus.done : ActionStatus.todo;
                queue.add(new Action.BuildClean(status, cElement));
                break;
            }
            case eclipse_setup: {
                if (!((Element)element).isWorkspace()) break;
                WorkspaceProject eproject = cElement.createEclipseProject();
                ActionStatus status = eproject.isProjectDirty() ? ActionStatus.dirty : ActionStatus.todo;
                queue.add(new Action.EclipseSetup(status, cElement));
                break;
            }
            case eclipse_unsetup: {
                cElement.createEclipseProject();
                ActionStatus status = ActionStatus.todo;
                queue.add(new Action.EclipseUnsetup(status, cElement));
            }
        }
    }

    protected Element resolveElement(EBuildContext from, String source, EKey dkey) throws EBuildException {
        Element r = from.resolveElement(source, dkey);
        Pair<EKey, EKey> res = new Pair<EKey, EKey>(dkey, r.key);
        if (!this.resolved.contains(res)) {
            this.resolved.add(res);
            this.report.resolve((EKey)res.a, (EKey)res.b);
        }
        return r;
    }

    private Module resolveModule(EBuildContext from, CmnXml.SelectWithSource d) throws EBuildException {
        EKey dkey = from.newElementKey(ElementType.module, d);
        return (Module)this.resolveElement(from, d.source, dkey);
    }

    protected EBuildContext resolveContext(Element element) throws EBuildException {
        return this.resolveContext(element.context, (CmnXml.EBuildRoot)element.getDeclaration());
    }

    protected EBuildContext resolveContext(ProjectHelper phelper) throws EBuildException {
        EBuildContext r = this.resolveContext(phelper.context, phelper.getBuildXml());
        return r;
    }

    private EBuildContext resolveContext(EBuildContext context, CmnXml.EBuildRoot xml) throws EBuildException {
        context.addParents(this.ebuild.context);
        for (CmnXml.Repository repoXml : xml.repositories) {
            context.addRepository(repoXml);
        }
        int l = xml.usings.size();
        EBuildContext[] add = new EBuildContext[l];
        int i = 0;
        while (i < l) {
            CmnXml.Using d = xml.usings.get(i);
            Module delement = this.resolveModule(context, d);
            EBuildContext dcontext = d.isBuild() ? this.resolveContext(delement.expectProjectHelper()) : this.resolveContext(delement);
            add[i] = dcontext;
            ++i;
        }
        context.addParents(add);
        return context;
    }

    protected void resolveBuildersForPart(ElementC cElement) throws EBuildException {
        Object element = cElement.element;
        if (!((Element)element).isSource()) {
            return;
        }
        ProjectHelper phelper = ((Element)element).getProjectHelper();
        EBuildContext bcontext = phelper.context;
        Backtrace.start("resolve builders", bcontext);
        try {
            this.resolveContext(phelper);
            ElementDeps deps = cElement.getDependencies(Scope.MAIN);
            Iterable<CmnXml.SelectWithSource> ds = phelper.getBuildDependencies(cElement.getSubKey());
            for (CmnXml.SelectWithSource d : ds) {
                if (d.isRefId()) continue;
                EKey bekey = bcontext.newModuleKey(d);
                Module belement = (Module)this.resolveElement(bcontext, d.source, bekey);
                ElementC cModule = belement.getDefault();
                ArtifactKey bcekey = new ArtifactKey(belement.key);
                ModuleBuildPlan subPlan = (ModuleBuildPlan)this.runner.buildPlans.get(cModule.key);
                if (subPlan == null) {
                    if (!(belement instanceof Module)) {
                        throw EBuildException.newProblem("Builder element is not a module, got: " + belement.getType());
                    }
                    subPlan = new ModuleBuildPlan(this.runner, cModule);
                    assert (subPlan.getKey().equals(bcekey));
                    assert (this.runner.buildPlans.get(bcekey) != null);
                    this.report.addPlan(subPlan);
                }
                Backtrace.checkCycle("resolve and configure", subPlan.getKey());
                this.builderPlans.add(subPlan.getKey());
                deps.addBuilder(bekey, belement);
                String id = d.getId();
                if (id == null || bcontext.getBuilder(id) != null) continue;
                bcontext.addBuilder(id, new BuilderInstance(belement, ((CmnXml.Builder)d).propertiesList));
            }
        }
        finally {
            Backtrace.end(bcontext);
        }
    }

    public String toString() {
        return "" + this.getKey();
    }
}

