/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.BuilderInstance;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderChain {
    final List<BuilderInstance> builders;
    private final Set<String> intermediates = new HashSet<String>();
    private final Set<String> terminals = new HashSet<String>();

    public BuilderChain(List<BuilderInstance> builders) {
        this.builders = builders;
        int i = builders.size() - 1;
        while (i >= 0) {
            BuilderInstance bi = builders.get(i);
            Set<String> inputs = bi.getProtoType().inputs;
            Set<String> outputs = bi.getProtoType().outputs;
            if (inputs == null) {
                this.intermediates.add("*");
                this.terminals.addAll(outputs);
            } else if (inputs != null && !bi.getProtoType().isIdentity()) {
                this.intermediates.addAll(inputs);
            }
            --i;
        }
    }

    public boolean isIntermediate(String artifactType) {
        if (this.intermediates.contains("*")) {
            return !this.terminals.contains(artifactType);
        }
        return this.intermediates.contains(artifactType);
    }

    public List<BuilderInstance> getBuilders() {
        return this.builders;
    }
}

