/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.base.PluginUtil;
import ebuild.core.Action;
import ebuild.core.ActionQueue;
import ebuild.core.ActionStatus;
import ebuild.core.BuildPlan;
import ebuild.core.BuildResolutionReport;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.ModuleVersion;
import ebuild.core.ProductBuildPlan;
import ebuild.core.impl.Task;
import ebuild.core.impl.TaskSet;
import ebuild.util.Logger;
import ebuild.util.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class EBuildRunner {
    protected final EBuild ebuild;
    protected final Logger logger;
    final BuildResolutionReport report;
    public final ActionQueue queue = new ActionQueue();
    final Map<Object, BuildPlan> buildPlans = new LinkedHashMap<Object, BuildPlan>();

    public EBuildRunner(EBuild ebuild) {
        this.ebuild = ebuild;
        this.logger = ebuild.logger;
        this.report = BuildResolutionReport.newReport(ebuild.isVerbose());
    }

    public EBuildRunner(ClassLoader apiClassLoader, EBuild.Options options) {
        this(new EBuild(apiClassLoader, options));
    }

    public abstract String getKey();

    public abstract void go() throws Exception;

    protected void log(String msg) {
        this.logger.log(msg);
    }

    protected void loge(String msg) {
        String[] stringArray = msg.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.logger.log("!! " + s);
            ++n2;
        }
    }

    public void run() throws Exception {
        if (this.ebuild.isDEBUG()) {
            this.logger.log("system classloader path: ");
            this.logger.log(PluginUtil.displayClassloader(this.ebuild, ClassLoader.getSystemClassLoader()));
            this.logger.log("core classloader path: ");
            this.logger.log(PluginUtil.displayClassloader(this.ebuild, EBuildRunner.class.getClassLoader()));
        }
        try {
            try {
                this.go();
            }
            catch (Throwable e) {
                this.log("");
                this.log("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                this.log("!!! PROBLEM                                                 (" + EBuildRunner.versionCode() + ")");
                Logger l = this.logger.newSubLogger(null, null, " !!");
                EBuildException.printReport(l, this.ebuild.isDEBUG(), e);
                this.log("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                this.logger.prime();
            }
        }
        finally {
            this.logger.prime();
        }
    }

    private static String versionCode() {
        if (ModuleVersion.TAG != null) {
            return ModuleVersion.TAG;
        }
        String r = "";
        if ("trunk" != null) {
            r = "trunk/";
        }
        return String.valueOf(r) + "347";
    }

    protected BuildPlan newBuildPlan(ElementC cElement, Scope scope) {
        switch (((Element)cElement.element).key.type) {
            case module: {
                return new ModuleBuildPlan(this, cElement);
            }
            case product: {
                return new ProductBuildPlan(this, cElement);
            }
        }
        throw new Error("!");
    }

    public void go(ElementC cElement, Task task) throws Exception {
        this.go(this.newBuildPlan(cElement, task.getScope()), task);
    }

    public void go(BuildPlan mainPlan, Task task) throws Exception {
        TaskSet tasks = new TaskSet(task);
        this.log("");
        this.log("");
        this.log("////////////////////////////////////");
        this.log("////// Resolve And Configure ///////");
        this.log("");
        this.resolveAndConfigure(mainPlan, tasks);
        this.log("");
        this.log("");
        this.log("////////////////////////////");
        this.log("////// Plan Task List //////");
        this.log("");
        this.buildActionList(mainPlan, tasks);
        this.log("");
        this.log("");
        this.log("//////////////////////////");
        this.log("////// Execute Plan //////");
        this.log("");
        this.run(this.queue);
    }

    protected void resolveAndConfigure(BuildPlan mainPlan, TaskSet tasks) throws EBuildException {
        this.report.setMainPlan(mainPlan);
        mainPlan.resolveAndConfigure(tasks);
        if (this.ebuild.isDEBUG()) {
            this.log("");
            this.log("Build Plans");
            for (Object k : this.buildPlans.keySet()) {
                this.log("  " + k);
            }
        }
    }

    private void buildActionList(BuildPlan mainPlan, TaskSet tasks) throws Exception {
        String key = this.getKey();
        Backtrace.startTop("plan actions", key);
        try {
            mainPlan.buildActionList(this.queue, tasks);
        }
        finally {
            Backtrace.endTop(key);
        }
        this.queue.removeDuplicates();
        for (Action a : this.queue) {
            this.log("queued " + StringUtil.rpad(7, a.status.displayString()) + " " + a.format());
        }
    }

    private void run(ActionQueue queue) throws Exception {
        for (Action action : queue) {
            if (action.status == ActionStatus.done && !this.ebuild.options.noSkipping) {
                this.log("- skipping  " + action + " -");
                this.logger.setProvisionalHeading("\n");
                action.finish(true);
                this.logger.setProvisionalHeading(null);
                continue;
            }
            this.log("- executing " + action + " -");
            this.logger.setProvisionalHeading("\n");
            action.run(this.logger);
            this.logger.setProvisionalHeading(null);
        }
    }
}

