/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.IRepository;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.compat.AbstractCompatability;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.ElementC;
import ebuild.core.ElementNature;
import ebuild.core.ElementResolver;
import ebuild.core.ProjectHelper;
import ebuild.core.WorkspaceProject;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.impl.SubKey;
import ebuild.core.impl.Version;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.version.EBuildVersion;
import ebuild.xml.CmnXml;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element<D extends CmnXml.EBuildElement> {
    public final EBuild ebuild;
    private final File dir;
    public final ElementResolver resolver;
    public final EBuildMode mode;
    public final EBuildContext context;
    private IRepository repository = null;
    private AbstractWorkingCopy workingCopy = null;
    public final EKey key;
    private final File metaDir;
    protected D declaration;
    private final File buildDir;
    private final File releaseDir;
    private final File projectDir;
    public final ElementNature nature;
    private ProjectHelper projectHelper;
    private WorkspaceProject eclipseProject;
    private Map<SubKey, ElementC> cElements = new HashMap<SubKey, ElementC>();
    private Long lastModified = null;

    public Element(EBuildMode mode, File directory, EBuild ebuild, EKey key, ElementNature nature) throws EBuildException {
        assert (key.universe != null);
        this.ebuild = ebuild;
        this.dir = FileUtil.canonicalFile(directory);
        this.mode = mode;
        this.resolver = ebuild;
        this.context = new EBuildContext(this, EBuildContext.Type.main);
        this.key = key;
        this.metaDir = FileUtil.canonicalFile(this.getFile("meta"));
        this.projectDir = FileUtil.canonicalFile(this.getFile(mode == EBuildMode.library ? "project" : "."));
        this.buildDir = FileUtil.canonicalFile(this.getFile("build"));
        this.releaseDir = FileUtil.canonicalFile(this.getFile("release"));
        this.nature = nature;
        if (this.isSource()) {
            this.projectHelper = this.newProjectHelper();
        }
    }

    public abstract ElementC newCElement(SubKey var1, ConfSet var2);

    public abstract ProjectHelper newProjectHelper() throws EBuildException;

    public abstract void initDeclaration() throws EBuildException;

    public EBuildVersion getMetaVersion(MetaType type) throws EBuildException {
        File f;
        block3: {
            try {
                f = this.getMetaFile(type);
                if (f != null) break block3;
                return null;
            }
            catch (Exception e) {
                throw EBuildException.newProblem(this.ebuild.formatAsDisplayPath(this.dir), e);
            }
        }
        return EBuildVersion.readVersion(f);
    }

    public CmnXml.EBuildRoot getMeta(MetaType type) throws EBuildException {
        FileInputStream fi;
        File f = this.getMetaFile(type);
        try {
            fi = new FileInputStream(f);
        }
        catch (IOException e) {
            throw EBuildException.newError("Expected file: " + f, e);
        }
        EBuildVersion v = this.getMetaVersion(type);
        if (v == null) {
            return null;
        }
        AbstractCompatability compat = this.ebuild.getCompatability(v);
        boolean verbose = false;
        return compat.parseXml(type, fi, verbose);
    }

    public CmnXml.EBuildRoot expectMeta(MetaType type) throws EBuildException {
        CmnXml.EBuildRoot r = this.getMeta(type);
        if (r == null) {
            throw EBuildException.newProblem("Expected meta file: " + type.name);
        }
        return r;
    }

    public File javaFile() {
        return this.dir;
    }

    public File getFile(String name) {
        return new File(this.dir, name);
    }

    public boolean isWorkspace() {
        return this.mode == EBuildMode.workspace;
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IRepository repository) {
        this.repository = repository;
        this.context.addRepository("local", repository, this.key.org);
        if (this.isSource()) {
            this.getProjectHelper().context.addRepository("local", repository, this.key.org);
        }
    }

    public AbstractWorkingCopy getWorkingCopy() {
        return this.workingCopy;
    }

    public void setWorkingCopy(AbstractWorkingCopy workingCopy) {
        this.workingCopy = workingCopy;
    }

    public boolean hasMetaDirectory() {
        return this.metaDir.exists();
    }

    public File getMetaDirectory() {
        return this.metaDir;
    }

    public File getMetaFile(MetaType type) {
        File r = new File(this.metaDir, String.valueOf(EBuildVersion.getLatest().string) + "/" + type.name);
        if (r.isFile()) {
            return r;
        }
        r = new File(this.metaDir, type.name);
        if (r.isFile()) {
            return r;
        }
        String name = type.getAlternativeName();
        if (name != null) {
            r = new File(this.metaDir, name);
        }
        if (r.isFile()) {
            return r;
        }
        return null;
    }

    public boolean hasMetaFile(MetaType type) {
        return this.getMetaFile(type) != null;
    }

    public abstract ElementType getType();

    public D getDeclaration() {
        return this.declaration;
    }

    public String getName() {
        return this.key.fullname();
    }

    public Version getVersion() {
        return this.key.version;
    }

    public String toString() {
        return "" + this.key;
    }

    public long lastModificationOfSource() {
        if (this.lastModified == null) {
            long r = Long.MIN_VALUE;
            File[] fs = this.getProjectDirectory().listFiles();
            if (fs != null) {
                File[] fileArray = fs;
                int n = fs.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.getName().startsWith("src")) {
                        r = Math.max(r, FileUtil.deepLastModified(f));
                    }
                    ++n2;
                }
                r = Math.max(r, FileUtil.deepLastModified(this.getMetaDirectory()));
            } else {
                r = Long.MAX_VALUE;
            }
            this.lastModified = r;
        }
        return this.lastModified;
    }

    public boolean hasBuildDirectory() {
        return this.buildDir.exists();
    }

    public File getBuildDirectory() {
        return this.buildDir;
    }

    public boolean hasReleaseDirectory() {
        return this.releaseDir.exists();
    }

    public File getReleaseDirectory() {
        return this.releaseDir;
    }

    public boolean hasProjectDirectory() {
        return this.projectDir.exists();
    }

    public File getProjectDirectory() {
        return this.projectDir;
    }

    public boolean buildIsClean() {
        return !this.hasBuildDirectory() && !this.hasReleaseDirectory();
    }

    public void buildClean() {
        FileUtil.deleteDir(this.getBuildDirectory());
        FileUtil.deleteDir(this.getReleaseDirectory());
    }

    public ProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public ProjectHelper expectProjectHelper() throws EBuildException {
        ProjectHelper r = this.getProjectHelper();
        if (r == null) {
            throw EBuildException.newProblem("Build context unavailable: " + this.key);
        }
        return r;
    }

    private ConfSet actualConfiguration(ConfSet configurationSelected) throws EBuildException {
        HashSet<String> aliases = new HashSet<String>();
        HashMap<String, ConfSet> includes = new HashMap<String, ConfSet>();
        for (CmnXml.Configuration c : ((CmnXml.EBuildElement)this.getDeclaration()).configurations) {
            ConfSet confs = EBuildUtil.parseConfSet(c.includes);
            if (c.alias) {
                aliases.add(c.name);
            }
            includes.put(c.name, confs);
        }
        ConfSet.Builder b = new ConfSet.Builder();
        for (String c : configurationSelected.asCollection()) {
            if (includes.containsKey(c)) {
                b.addAll((ConfSet)includes.get(c));
            }
            if (aliases.contains(c)) continue;
            b.add(c);
        }
        return b.build();
    }

    public Set<String> listCheckedIn() {
        File dir = this.getFile("checkedin");
        if (!dir.isDirectory()) {
            return CollectionUtil.EMPTY_SET;
        }
        String[] fs = dir.list();
        HashSet<String> r = new HashSet<String>(fs.length);
        String[] stringArray = fs;
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            r.add(f);
            ++n2;
        }
        return r;
    }

    public ElementC getDefault() throws EBuildException {
        return this.getCPart(SubKey.DEFAULT);
    }

    public ElementC getCPart(SubKey subKey0) throws EBuildException {
        ConfSet configuration = this.actualConfiguration(subKey0.conf);
        SubKey subKey = new SubKey(configuration, subKey0.artifact, subKey0.exclude);
        ElementC r = this.cElements.get(subKey);
        if (r == null) {
            r = this.newCElement(subKey, subKey0.conf);
            this.cElements.put(r.key.subkey, r);
        }
        return r;
    }

    public WorkspaceProject createEclipseProject(ElementC cElement) {
        if (this.eclipseProject == null) {
            this.eclipseProject = cElement.newEclipseProject();
            try {
                this.eclipseProject.storeConfiguration();
            }
            catch (IOException e) {
                throw new Error("Unable to store configuration", e);
            }
            return this.eclipseProject;
        }
        if (cElement.getConfiguration().equals(this.eclipseProject.getConfiguration())) {
            return this.eclipseProject;
        }
        throw new Error("Attempted to have eclipse project for '" + this.key + "'with 2 different configurations: " + "\n" + cElement.getConfiguration() + "\n" + this.eclipseProject.getConfiguration());
    }

    public WorkspaceProject expectEclipseProject() {
        if (this.eclipseProject == null) {
            throw new RuntimeException("No eclipse project for " + this.key);
        }
        return this.eclipseProject;
    }

    public boolean isSource() {
        return this.nature.isSource();
    }

    public void addIgnores(List<String> patterns) {
        if (!this.isWorkspace()) {
            throw new Error("Tryed to add a ignores to a non-workspace element: " + this);
        }
        AbstractWorkingCopy wc = this.getWorkingCopy();
        if (wc == null) {
            return;
        }
        wc.addIgnores(patterns);
    }

    public void addIgnores(String ... patterns) {
        this.addIgnores(CollectionUtil.newList(patterns));
    }

    public Date getLastCommitDate() {
        if (this.isWorkspace()) {
            return new Date();
        }
        Date r = FileUtil.readTimestampFile(this.getMetaDirectory());
        if (r == null) {
            r = new Date(this.getProjectDirectory().lastModified());
        }
        return r;
    }
}

