/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.EBuildException;
import ebuild.core.BuildProject;
import ebuild.core.Element;
import ebuild.core.ElementDeps;
import ebuild.core.ElementRelease;
import ebuild.core.WorkspaceProject;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.ArtifactKey;
import ebuild.core.impl.SubKey;
import ebuild.core.util.WorkMarker;
import ebuild.util.FileUtil;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementC<P extends Element> {
    public final ArtifactKey key;
    public final P element;
    public final ConfSet configurationSelected;
    public final ElementRelease<P> release;
    public BuildProject<P> build;
    public WorkspaceProject<P> eclipse;
    private Long lastModificationOfInput = null;

    public BuildProject<P> createBuildProject() {
        this.build = this.newBuildProject();
        return this.build;
    }

    public WorkspaceProject<P> createEclipseProject() {
        this.eclipse = this.newEclipseProject();
        return this.eclipse;
    }

    public ElementRelease<P> registerRelease() throws EBuildException {
        return this.release;
    }

    public ElementC(P element, SubKey subKey, ConfSet configurationSelected) {
        this.key = new ArtifactKey(((Element)element).key, subKey);
        this.element = element;
        this.configurationSelected = configurationSelected;
        this.release = this.newRelease();
    }

    public WorkMarker getWorkMarker() {
        return this.release.getWorkMarker();
    }

    public abstract WorkspaceProject newEclipseProject();

    public abstract BuildProject newBuildProject();

    public abstract ElementRelease newRelease();

    public abstract ElementDeps getDependencies(Scope var1);

    public SubKey getSubKey() {
        return this.key.subkey;
    }

    public String getArtifact() {
        return this.key.subkey.artifact;
    }

    public P getPart() {
        return this.element;
    }

    public ConfSet getConfiguration() {
        return this.key.subkey.conf;
    }

    public ConfSet getConfigurationSelected() {
        return this.configurationSelected;
    }

    public long lastModificationOfInput(Scope scope) {
        if (this.lastModificationOfInput == null) {
            long r = this.getDependencies(scope).lastModified();
            if (((Element)this.element).isSource()) {
                r = Math.max(r, ((Element)this.element).lastModificationOfSource());
            }
            this.lastModificationOfInput = r;
        }
        return this.lastModificationOfInput;
    }

    public long lastModification(Scope scope) {
        long r = this.lastModificationOfInput(scope);
        r = Math.max(r, FileUtil.deepLastModified(this.getReleaseDirectory()));
        return r;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        ElementC b = (ElementC)obj;
        return this.key.equals(b.key);
    }

    public String toString() {
        return this.key.toString();
    }

    public File getReleaseDirectory() {
        return new File(((Element)this.getPart()).getReleaseDirectory(), this.getConfiguration().asDirectoryName());
    }
}

