/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.base.BuildPluginType;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.compat.IBuildPlugin;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ElementNature;
import ebuild.core.ModuleC;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.ModuleRelease;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.SubKey;
import ebuild.util.Logger;
import ebuild.version.EBuildVersion;
import ebuild.xml.ModXml;
import java.io.File;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module
extends Element<ModXml.EbuildModule> {
    final IBuildPlugin buildPlugin = this.getBuildPlugin();
    public static final Exclude NOAPI = Exclude.newExclude(new Exclude.Rule("ebuild", "api.*", null, null, null), new Exclude.Rule("ebuild", "compat", null, null, null));

    public Module(EBuildMode mode, File directory, EBuild ebuild, EKey key, ElementNature nature) throws EBuildException {
        super(mode, directory, ebuild, key, nature);
    }

    private IBuildPlugin getBuildPlugin() throws EBuildException {
        EBuildVersion v = this.getMetaVersion(MetaType.BUILD_PLUGIN);
        if (v == null) {
            return null;
        }
        try {
            return this.ebuild.getCompatability(v).getPlugin(this.getMetaFile(MetaType.BUILD_PLUGIN));
        }
        catch (Exception e) {
            throw EBuildException.newProblem("Could not load build plugin: " + this.key, e);
        }
    }

    @Override
    public ModuleC newCElement(SubKey subKey, ConfSet confSelected) {
        return new ModuleC(this, subKey, confSelected);
    }

    public ModuleC getCElement(SubKey subKey) throws EBuildException {
        return (ModuleC)super.getCPart(subKey);
    }

    @Override
    public ModuleProjectHelper newProjectHelper() {
        return new ModuleProjectHelper(this);
    }

    @Override
    public ModuleProjectHelper getProjectHelper() {
        return (ModuleProjectHelper)super.getProjectHelper();
    }

    @Override
    public ElementType getType() {
        return ElementType.module;
    }

    @Override
    public void initDeclaration() throws EBuildException {
        this.declaration = (ModXml.EbuildModule)this.expectMeta(MetaType.MODULE);
    }

    public boolean isPlugin() {
        return this.buildPlugin != null;
    }

    public Iterable<ModXml.Dependency> getDependenciesXml() {
        return ((ModXml.EbuildModule)this.getDeclaration()).dependencies.list;
    }

    public String getJavaVersion() {
        for (ModXml.System d : ((ModXml.EbuildModule)this.getDeclaration()).dependencies.systems) {
            if (!"java.jre".equals(d.name) || d.tag == null) continue;
            return d.tag;
        }
        return "1.6";
    }

    public void registerRelease(ElementC cElement) throws EBuildException {
        if (this.isPlugin()) {
            Collection<String> classpath = this.getClassPath(cElement, Scope.MAIN);
            BuildPluginType type = this.buildPlugin.getType();
            if (type.isSystemPlugin()) {
                this.ebuild.PLUGINS.registerSystemPlugin(cElement, classpath);
            } else {
                this.buildPlugin.instantiate(this.ebuild, this.ebuild.apiClassLoader, classpath);
                switch (type) {
                    case ASSEMBLER: {
                        this.ebuild.registerAssembler(this.key, this.buildPlugin.asAssembler());
                        break;
                    }
                    case BUILDER: {
                        this.ebuild.registerBuilder(this.key, this.buildPlugin.asBuilder(this.key));
                        break;
                    }
                    case REPO: 
                    case COMPAT: {
                        throw new Error("!");
                    }
                }
            }
        }
    }

    private Collection<String> getClasspath_(ElementC cElement, Scope scope) {
        ModuleRelease mr = (ModuleRelease)cElement.release;
        return mr.getClassPath(NOAPI);
    }

    private void logPluginPath(Collection<String> elements) {
        Logger l = this.ebuild.logger;
        l.log("plugin runtime path for '" + this.key + "': ");
        for (String s : elements) {
            l.log("    " + this.ebuild.formatAsDisplayPath(new File(s)));
        }
    }

    public Collection<String> getClassPath(ElementC cElement, Scope scope) {
        Collection<String> elements = this.getClasspath_(cElement, scope);
        if (this.ebuild.isDEBUG() || this.ebuild.isVerbose()) {
            this.logPluginPath(elements);
        }
        return elements;
    }

    public boolean isApi() {
        return this.key.universe == null && "ebuild".equals(this.key.org) && this.key.name.startsWith("api");
    }
}

