/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.EBuildRunner;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleDeps;
import ebuild.core.conf.ConfExpr;
import ebuild.core.conf.ConfMapping;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.SubKey;
import ebuild.core.impl.Task;
import ebuild.core.impl.TaskSet;
import ebuild.xml.ModXml;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleBuildPlan
extends BuildPlan {
    public final String artifact;
    private final Map<EKey, Node> nodes = new HashMap<EKey, Node>();
    private final SelectionNode initialNode = new SelectionNode();
    private ConfSet groupConfs = ConfSet.EMPTY;
    private TaskSet resolvedFor = TaskSet.NONE;
    private static final EKey INITNODE_KEY = EKey.newUnversioned(null, "-system-", "-dummy-");

    public ModuleBuildPlan(EBuildRunner runner, Object key, String artifact) {
        super(runner, key);
        this.artifact = artifact;
        this.nodes.put(this.initialNode.key, this.initialNode);
    }

    public ModuleBuildPlan(EBuildRunner runner, ElementC<Module> cmodule) {
        this(runner, cmodule, Exclude.NONE);
    }

    public ModuleBuildPlan(EBuildRunner runner, ElementC<Module> cmodule, Exclude exclude) {
        this(runner, cmodule.key, cmodule.getArtifact());
        this.addModule((Module)cmodule.element, cmodule.getConfiguration(), exclude);
    }

    public void addModule(Module m, ConfSet confs, Exclude exclude) {
        ModuleNode mnode = this.addNode(m, exclude);
        ConfMapping mapping = EBuildUtil.newMapping(confs);
        this.initialNode.addOutgoing(new Outgoing(m.key, mnode, ConfExpr.TRUE, Scope.MAIN, mapping, false));
    }

    public void setGroupConfs(ConfSet groupConfs) {
        this.groupConfs = groupConfs;
    }

    public Module expectModule() {
        return (Module)this.expectLoneCPart().element;
    }

    public ElementC expectLoneCPart() {
        Collection<ElementC> cElements = this.getPrimaryModules();
        if (cElements.size() != 1) {
            throw new Error("Expected single module, got '" + cElements.size() + ". Is plan ModuleSelection?");
        }
        return cElements.iterator().next();
    }

    public Collection<ElementC> getPrimaryModules() {
        Map os = this.initialNode.outgoing;
        ArrayList<ElementC> r = new ArrayList<ElementC>(os.size());
        for (EKey ekey : os.keySet()) {
            Outgoing o = (Outgoing)os.get(ekey);
            if (o.scope != Scope.MAIN) continue;
            r.add(o.node.moduleC);
        }
        return r;
    }

    private ModuleNode addNode(Module p, Exclude exclude) {
        ModuleNode r = this.addNode(p.key);
        r.set(p, exclude);
        return r;
    }

    private ModuleNode addNode(EKey key) {
        ModuleNode r = (ModuleNode)this.nodes.get(key);
        if (r == null) {
            r = new ModuleNode(key);
            this.nodes.put(r.key, r);
        }
        return r;
    }

    @Override
    public void resolveAndConfigure_(TaskSet tasks) throws EBuildException {
        if (this.resolvedFor.includes(tasks)) {
            return;
        }
        this.resolvedFor = this.resolvedFor.combine(tasks);
        this.report.startResolveMain();
        this.initialNode.resolveDependencies(tasks);
        this.report.startSection("\n--- Configure ---");
        this.configure();
    }

    protected Collection<ElementC> gatherReleases() {
        HashSet<ElementC> r = new HashSet<ElementC>();
        for (Node n : this.nodes.values()) {
            if (!(n instanceof ModuleNode)) continue;
            ModuleNode mn = (ModuleNode)n;
            r.add(mn.moduleC);
        }
        return r;
    }

    @Override
    protected void resolveBuilders(TaskSet tasks) throws EBuildException {
        this.initialNode.resolveBuilders(tasks);
    }

    private void configure() throws EBuildException {
        LinkedList<Node> reverseOrder;
        block8: {
            int sizeBefore;
            int sizeAfter;
            HashSet<Node> nodes = new HashSet<Node>(this.nodes.values());
            reverseOrder = new LinkedList<Node>();
            do {
                sizeBefore = nodes.size();
                Iterator I = nodes.iterator();
                while (I.hasNext()) {
                    Node n = (Node)I.next();
                    if (n.ignore()) {
                        I.remove();
                        continue;
                    }
                    if (!n.isConfigurable()) continue;
                    Backtrace.start("configure module", n.key);
                    try {
                        n.configure();
                    }
                    finally {
                        Backtrace.end(n.key);
                    }
                    I.remove();
                    reverseOrder.addFirst(n);
                    break;
                }
                sizeAfter = nodes.size();
                if (sizeAfter == 0) break block8;
            } while (sizeAfter != sizeBefore);
            throw new Error("Could not configure due to cyclical dependency: " + nodes);
        }
        for (Node n : reverseOrder) {
            if (!(n instanceof ModuleNode)) continue;
            ModuleNode mn = (ModuleNode)n;
            mn.setDependencies();
        }
    }

    @Override
    protected void buildActionList_(ActionQueue queue, TaskSet tasks) throws Exception {
        this.initialNode.buildActionList(queue, tasks);
    }

    private class LazyOutgoing
    extends Outgoing {
        final String source;
        final Exclude exclude;

        LazyOutgoing(EKey dkey, ModuleNode node, ConfExpr confs, Scope scope, ConfMapping mapping, boolean subsumed, String source, Exclude exclude) {
            super(dkey, node, confs, scope, mapping, subsumed);
            this.source = source;
            this.exclude = exclude;
        }

        public void resolve(TaskSet tasks, Module from) throws EBuildException {
            Module dmodule = (Module)ModuleBuildPlan.this.resolveElement(from.context, this.source, this.dkey);
            this.node.set(dmodule, this.exclude);
            super.resolve(tasks, from);
        }
    }

    private class ModuleNode
    extends Node {
        private Module module;
        private boolean processed;
        private Exclude exclude;
        private TaskSet resolvedFor;
        private ModuleC moduleC;

        public ModuleNode(EKey key) {
            super(key);
            this.processed = false;
            this.exclude = Exclude.NONE;
            this.resolvedFor = TaskSet.NONE;
            this.moduleC = null;
        }

        void set(Module module, Exclude exclude) {
            if (this.module != null) assert (this.module == module);
            this.module = module;
            this.exclude = Exclude.combine(this.exclude, exclude);
        }

        protected boolean skipDependency(Outgoing o) {
            return this.skipDependency(o.dkey, o.subsumed);
        }

        private boolean skipDependency(EKey dkey, boolean subsumed) {
            if (this.module.isSource()) {
                return false;
            }
            if (subsumed) {
                return true;
            }
            return this.exclude.match(dkey);
        }

        private void resolveContextAndProcessDependencies() throws EBuildException {
            if (this.processed) {
                return;
            }
            this.processed = true;
            Backtrace.start("resolve context", this.module.context);
            try {
                ModuleBuildPlan.this.resolveContext(this.module);
                Iterable<ModXml.Dependency> deps = this.module.getDependenciesXml();
                for (ModXml.Dependency d : deps) {
                    String source = d.source;
                    if ("system".equals(source)) continue;
                    EKey dkey = this.module.context.newModuleKey(d);
                    Scope dscope = EBuildUtil.getScope(d.scope, Scope.MAIN);
                    ConfExpr dconfs = EBuildUtil.parseConfExpr(d.conf);
                    Exclude dexcludes = Exclude.newExclude(d.excludes);
                    Backtrace.start("process dependency", dkey);
                    try {
                        ModuleNode dnode = ModuleBuildPlan.this.addNode(dkey);
                        ConfMapping dmapping = EBuildUtil.parseMapping(d.confMapping, ConfMapping.EMPTY);
                        this.addOutgoing(new LazyOutgoing(dkey, dnode, dconfs, dscope, dmapping, d.subsumed, source, dexcludes));
                    }
                    finally {
                        Backtrace.end(dkey);
                    }
                }
            }
            finally {
                Backtrace.end(this.module.context);
            }
        }

        void resolveDependencies(TaskSet tasks) throws EBuildException {
            if (this.resolvedFor.includes(tasks)) {
                return;
            }
            this.resolvedFor = this.resolvedFor.combine(tasks);
            this.resolveContextAndProcessDependencies();
            Scope scope = tasks.getScope();
            Backtrace.start("resolve dependencies", this.module.context);
            try {
                for (Outgoing o : this.outgoing.values()) {
                    if (!scope.includes(o.scope) || this.skipDependency(o)) continue;
                    o.resolve(tasks, this.module);
                }
            }
            finally {
                Backtrace.end(this.module.context);
            }
        }

        public boolean ignore() {
            return this.module == null;
        }

        void configure() throws EBuildException {
            super.configure();
            ModuleBuildPlan.this.report.configure(this.module.key, this.conf_node);
            this.moduleC = this.module.getCElement(new SubKey(this.conf_node, ModuleBuildPlan.this.artifact, this.exclude));
        }

        public void setDependencies() throws EBuildException {
            this.setDependencies(this.resolvedFor.getScope());
        }

        public void setDependencies(Scope scope) throws EBuildException {
            if (this.moduleC.getDependencies(scope) != null) {
                return;
            }
            Scope pscope = scope.getParent();
            ModuleDeps pdeps = null;
            if (pscope != null) {
                this.setDependencies(pscope);
                pdeps = this.moduleC.getDependencies(pscope);
            }
            ModuleDeps deps = new ModuleDeps(this.moduleC, scope, pdeps);
            this.setDependencies(scope, deps);
            this.moduleC.setDependencies(scope, deps);
        }

        private void setDependencies(Scope scope, ModuleDeps deps) throws EBuildException {
            Backtrace.start("setup dependencies", this.module.context);
            try {
                Scope dscope;
                for (Outgoing o : this.outgoing.values()) {
                    if (o.scope != scope || !o.confs.evaluate(this.conf_node) || this.skipDependency(o)) continue;
                    ModuleC cElement = o.node.moduleC;
                    deps.addPart(new ModuleDeps.ElementDep(o.scope, cElement, o.subsumed));
                }
                for (ModXml.CheckedIn checkedIn : ((ModXml.EbuildModule)this.module.getDeclaration()).dependencies.checkedIns) {
                    dscope = EBuildUtil.getScope(checkedIn.scope, Scope.MAIN);
                    if (scope != dscope || !EBuildUtil.evaluateExpr(checkedIn.conf, this.conf_node)) continue;
                    ModuleDeps moduleDeps = deps;
                    moduleDeps.getClass();
                    deps.addCheckedIn(new ModuleDeps.CheckedInDep(moduleDeps, dscope, checkedIn.name, checkedIn.type));
                }
                for (ModXml.System system : ((ModXml.EbuildModule)this.module.getDeclaration()).dependencies.systems) {
                    dscope = EBuildUtil.getScope(system.scope, Scope.MAIN);
                    if (scope != dscope || !EBuildUtil.evaluateExpr(system.conf, this.conf_node)) continue;
                    ModuleDeps moduleDeps = deps;
                    moduleDeps.getClass();
                    deps.addSystem(new ModuleDeps.SystemDep(moduleDeps, dscope, system.name, system.tag));
                }
            }
            finally {
                Backtrace.end(this.module.context);
            }
        }

        void resolveBuilders(TaskSet tasks) throws EBuildException {
            ModuleBuildPlan.this.resolveBuildersForPart(this.moduleC);
            super.resolveBuilders(tasks);
        }

        public void buildActionListForNode(ActionQueue queue, TaskSet tasks) throws Exception {
            ModuleBuildPlan.this.buildActionListForPart(queue, (ElementC)this.moduleC, tasks);
        }
    }

    private abstract class Node {
        final EKey key;
        final Map<EKey, Node> incoming = new HashMap<EKey, Node>();
        final Map<EKey, ConfSet> incomingConfs = new HashMap<EKey, ConfSet>();
        final Map<EKey, Outgoing> outgoing = new HashMap<EKey, Outgoing>();
        ConfSet conf_node = null;

        Node(EKey key) {
            this.key = key;
        }

        public boolean ignore() {
            return false;
        }

        protected boolean skipDependency(Outgoing o) {
            return false;
        }

        private EKey key() {
            return this.key;
        }

        public void addOutgoing(Outgoing outgoing) {
            this.outgoing.put(outgoing.dkey, outgoing);
            outgoing.node.incoming.put(this.key(), this);
        }

        void resolveBuilders(TaskSet tasks) throws EBuildException {
            Backtrace.start("resolve builders", this.key);
            try {
                Scope scope = tasks.getScope();
                for (Outgoing o : this.outgoing.values()) {
                    if (!scope.includes(o.scope) || !o.confs.evaluate(this.conf_node) || this.skipDependency(o)) continue;
                    o.node.resolveBuilders(tasks);
                }
            }
            finally {
                Backtrace.end(this.key);
            }
        }

        boolean isConfigured() {
            return this.conf_node != null;
        }

        boolean isConfigurable() {
            for (Node node : this.incoming.values()) {
                if (node.isConfigured()) continue;
                return false;
            }
            return true;
        }

        void configure() throws EBuildException {
            Module m;
            ConfSet.Builder builder = new ConfSet.Builder();
            for (ConfSet confs : this.incomingConfs.values()) {
                builder.addAll(confs);
            }
            if (this instanceof ModuleNode && (m = ((ModuleNode)this).module).isSource()) {
                builder.addAll(ModuleBuildPlan.this.groupConfs);
            }
            this.conf_node = builder.build();
            for (Outgoing o : this.outgoing.values()) {
                if (!o.confs.evaluate(this.conf_node)) continue;
                ConfSet out = o.mapping.evaluate(this.conf_node);
                o.node.incomingConfs.put(this.key(), out);
            }
        }

        private TaskSet requiredTasks(ElementC elementC, TaskSet tasks) {
            if (!((Element)elementC.element).isWorkspace()) {
                tasks = tasks.replace(Task.eclipse_unsetup, Task.build_clean);
                tasks = tasks.replace(Task.eclipse_setup, Task.build_release);
            }
            return tasks;
        }

        public void buildActionListForNode(ActionQueue queue, TaskSet tasks) throws Exception {
        }

        public void buildActionList(ActionQueue queue, TaskSet tasks) throws Exception {
            Backtrace.start("plan", this.key);
            try {
                Scope scope = tasks.getScope();
                for (Outgoing o : this.outgoing.values()) {
                    if (!scope.includes(o.scope) || !o.confs.evaluate(this.conf_node) || this.skipDependency(o)) continue;
                    ModuleC moduleC = o.node.moduleC;
                    TaskSet tasks2 = this.requiredTasks(moduleC, tasks);
                    o.node.buildActionList(queue, tasks2);
                }
                this.buildActionListForNode(queue, tasks);
            }
            finally {
                Backtrace.end(this.key);
            }
        }

        public String toString() {
            return this.key + " " + (this.conf_node == null ? "[unconfigured]" : "" + this.conf_node);
        }
    }

    private static class Outgoing {
        final EKey dkey;
        final ModuleNode node;
        final ConfExpr confs;
        final Scope scope;
        final ConfMapping mapping;
        final boolean subsumed;

        Outgoing(EKey dkey, ModuleNode node, ConfExpr confs, Scope scope, ConfMapping mapping, boolean subsumed) {
            this.dkey = dkey;
            this.node = node;
            this.confs = confs;
            this.scope = scope;
            this.mapping = mapping;
            this.subsumed = subsumed;
        }

        public void resolve(TaskSet tasks, Module from) throws EBuildException {
            this.node.resolveDependencies(tasks);
        }
    }

    private class SelectionNode
    extends Node {
        SelectionNode() {
            super(INITNODE_KEY);
        }

        public void resolveDependencies(TaskSet tasks) throws EBuildException {
            for (Outgoing o : this.outgoing.values()) {
                o.resolve(tasks, null);
            }
        }
    }
}

