/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IModuleBuildProject;
import ebuild.api.IModuleRelease;
import ebuild.api.common.IElementKey;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.IPropertyMap;
import ebuild.base.MetaType;
import ebuild.compat.IModuleBuildProjectInCompat;
import ebuild.core.BuildProject;
import ebuild.core.BuilderChain;
import ebuild.core.BuilderInstance;
import ebuild.core.ElementC;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleDeps;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.ModuleRelease;
import ebuild.core.impl.EBuildUtil;
import ebuild.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleBuildProject
extends BuildProject<Module>
implements IModuleBuildProjectInCompat {
    private final Module module;
    private final ModuleProjectHelper helper;

    public ModuleBuildProject(ElementC<Module> cElement) {
        super((ElementC)cElement);
        this.module = cElement.getPart();
        this.helper = this.module.getProjectHelper();
    }

    public String getJavaVersion() {
        return this.helper.getJavaVersion();
    }

    public boolean isWorkspace() {
        return ((Module)this.getPart()).isWorkspace();
    }

    @Override
    public File getSrcDirectory(Scope scope, String type) {
        return this.helper.getSrcDirectory(scope, type);
    }

    public IElementKey getKey() {
        return this.module.key;
    }

    @Override
    public Collection<File> getCheckedInArtifacts(Scope s, String type) {
        return ModuleProjectHelper.getCheckedInArtifacts(this.cElement, s, type);
    }

    public String filePrefix() {
        return String.valueOf(this.getKey().fullnameAndVersion()) + this.getConfigurationSelected().asFileTrailingPart();
    }

    public Collection<File> getBuildDependencies(Scope scope, String artifactType) {
        ModuleDeps deps = (ModuleDeps)this.cElement.getDependencies(scope);
        ModuleDeps.GathererOfFiles gatherer = new ModuleDeps.GathererOfFiles(artifactType);
        deps.startDeepGather(gatherer, false, true);
        Set<File> artifacts = gatherer.files;
        artifacts.addAll(this.getCheckedInArtifacts(scope, artifactType));
        ModuleRelease release = this.getModuleRelease();
        Scope s = scope.getParent();
        while (s != null) {
            artifacts.addAll(release.getArtifacts(s, artifactType));
            s = s.getParent();
        }
        for (File a : artifacts) {
            System.err.println(this.module.ebuild.formatAsDisplayPath(a));
        }
        return artifacts;
    }

    public File getCorespondingBuildDependency(Scope scope, String artifactType, File artifact) {
        return ModuleProjectHelper.getCorespondingBuildDependency(this, scope, artifactType, artifact);
    }

    private File getGenDirectory(Scope s, String artifactType) {
        return new File(this.getIntermediateDirectory(), "gen/" + s.getName() + "/" + artifactType);
    }

    private File getIntermediateDirectory(String uniquePath) {
        return new File(this.getIntermediateDirectory(), "int/uniquePath");
    }

    @Override
    public long releaseLastModified() {
        return FileUtil.deepLastModified(this.cElement.getReleaseDirectory());
    }

    @Override
    public ModuleC getCPart() {
        return (ModuleC)super.getCPart();
    }

    private File getExportDirectory(Scope scope, String artifactType) {
        return new File(this.getModuleRelease().getFile(), String.valueOf(scope.getName()) + "/" + artifactType);
    }

    @Override
    public void buildRun() throws Exception {
        this.getModuleRelease().getFile().mkdirs();
        this.getModuleRelease().subsumeDependencies(Scope.MAIN);
        final BuilderChain chain = this.getCPart().configureAndParameterizeBuilderChain();
        for (BuilderInstance b : chain.getBuilders()) {
            ModuleProjectHelper.AbstractBuilderArgument arg = new ModuleProjectHelper.AbstractBuilderArgument(this, Scope.MAIN, b){

                public boolean isBuild() {
                    return true;
                }

                public boolean isFirstCall() {
                    return true;
                }

                public File getGenDirectory(String artifactType) {
                    return ModuleBuildProject.this.getGenDirectory(this.scope, artifactType);
                }

                public File getExportDirectory(String artifactType) {
                    return ModuleBuildProject.this.getExportDirectory(Scope.MAIN, artifactType);
                }

                public File getIntermediateDir(String uniquePath) {
                    return ModuleBuildProject.this.getIntermediateDirectory(uniquePath);
                }

                private File getOutputDir(String artifactType) {
                    if (chain.isIntermediate(artifactType)) {
                        return this.getGenDirectory(artifactType);
                    }
                    return this.getExportDirectory(artifactType);
                }

                public File getOutputArtifact(String artifactType, boolean alwaysNamed) {
                    if (alwaysNamed) {
                        String suffix = FileUtil.fileSuffix(artifactType);
                        artifactType = String.valueOf(artifactType) + ".group";
                        File export = this.getOutputDir(artifactType);
                        String fileName = ModuleBuildProject.this.filePrefix();
                        if (suffix != null) {
                            fileName = String.valueOf(fileName) + "." + suffix;
                        }
                        return new File(export, fileName);
                    }
                    return this.getOutputDir(artifactType);
                }

                public IModuleBuildProject getModuleBuildProject() {
                    return ModuleBuildProject.this;
                }
            };
            IPropertyMap props = arg.getPropertyMap();
            ILogger logger = arg.getLogger();
            logger.prime();
            logger.setProvisionalHeading("Properties");
            for (String k : props.listKeys()) {
                Object v = props.get(k);
                logger.log("    " + k + ": " + v);
            }
            b.build(arg);
        }
        FileFilter filter = EBuildUtil.getFileFilter(((Module)this.cElement.element).getRepository());
        for (String artifactType : this.helper.listSourceArtifacts(Scope.MAIN)) {
            if (chain.isIntermediate(artifactType)) continue;
            File target = this.getExportDirectory(Scope.MAIN, artifactType);
            target.mkdirs();
            File source = this.getSrcDirectory(Scope.MAIN, artifactType);
            FileUtil.copy(source, target, filter);
        }
    }

    @Override
    protected void buildEnd() throws Exception {
        super.buildEnd();
        if (this.module.buildPlugin != null) {
            FileUtil.copyToDirIfNewer(this.module.getMetaFile(MetaType.BUILD_PLUGIN), ((Module)this.getPart()).getReleaseDirectory());
        }
    }

    @Override
    public ModuleRelease getModuleRelease() {
        return (ModuleRelease)this.cElement.release;
    }

    @Override
    public Collection<IModuleRelease> getReleasedDependencies(Scope scope) {
        ModuleDeps deps = (ModuleDeps)this.cElement.getDependencies(scope);
        Collection<IModuleRelease> r = deps.asCollection();
        return r;
    }
}

