/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.EBuildException;
import ebuild.core.BuilderChain;
import ebuild.core.BuilderInstance;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.ElementC;
import ebuild.core.ElementRelease;
import ebuild.core.Module;
import ebuild.core.ModuleBuildProject;
import ebuild.core.ModuleDeps;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.ModuleRelease;
import ebuild.core.ModuleWorkspaceProject;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EKey;
import ebuild.core.impl.SubKey;
import ebuild.xml.CmnXml;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleC
extends ElementC<Module> {
    private BuilderChain buildChain;
    private Map<Scope, ModuleDeps> dependenciesMap = new HashMap<Scope, ModuleDeps>();

    public ModuleC(Module module, SubKey subKey, ConfSet configurationSelected) {
        super(module, subKey, configurationSelected);
    }

    @Override
    public ModuleBuildProject newBuildProject() {
        return new ModuleBuildProject((ElementC<Module>)this);
    }

    @Override
    public ModuleWorkspaceProject newEclipseProject() {
        return new ModuleWorkspaceProject((ElementC<Module>)this);
    }

    @Override
    public ElementRelease newRelease() {
        return new ModuleRelease((ElementC<Module>)this, this.getReleaseDirectory());
    }

    @Override
    public ElementRelease<Module> registerRelease() throws EBuildException {
        if (this.element instanceof Module) {
            Module m = (Module)this.element;
            try {
                m.registerRelease(this);
            }
            catch (Exception e) {
                EBuild ebuild = ((Module)this.element).ebuild;
                EBuildException e2 = EBuildException.newProblem("[WARNING] Unable to register plugin: " + ((Module)this.element).key, e);
                EBuildException.printReport(ebuild.logger, ebuild.isDEBUG(), e2);
            }
        }
        return super.registerRelease();
    }

    public BuilderChain getBuildChain() {
        return this.buildChain;
    }

    @Override
    public ModuleDeps getDependencies(Scope scope) {
        return this.dependenciesMap.get(scope);
    }

    public void setDependencies(Scope scope, ModuleDeps deps) {
        assert (!this.dependenciesMap.containsKey(scope));
        this.dependenciesMap.put(scope, deps);
    }

    public BuilderChain configureAndParameterizeBuilderChain() throws EBuildException {
        ModuleProjectHelper phelper = ((Module)this.element).getProjectHelper();
        EBuildContext bcontext = phelper.context;
        Iterable builderXmls = phelper.getBuildDependencies(this.getSubKey());
        ArrayList<BuilderInstance> builders = new ArrayList<BuilderInstance>(builderXmls.size());
        for (CmnXml.Builder bXml : builderXmls) {
            BuilderInstance builder;
            String refId = bXml.refid;
            if (refId != null) {
                builder = bcontext.getBuilder(refId);
                if (builder == null) {
                    throw EBuildException.newProblem("Unknown builder refId: " + refId);
                }
            } else {
                EKey bkey = phelper.context.newModuleKey(bXml);
                Module mod = (Module)this.getDependencies((Scope)Scope.MAIN).builders.get(bkey);
                builder = new BuilderInstance(mod, bXml.propertiesList);
            }
            builder.init();
            builders.add(builder);
        }
        this.buildChain = new BuilderChain(builders);
        return this.buildChain;
    }
}

