/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.EBuildException;
import ebuild.core.ElementDeps;
import ebuild.core.ElementRelease;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleRelease;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Exclude;
import ebuild.util.CollectionUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDeps
extends ElementDeps {
    public final ModuleDeps parent;
    public final Module module;
    public final Scope scope;
    public final Exclude exclude;
    private final Map<EKey, ElementDep> elements = new LinkedHashMap<EKey, ElementDep>();
    private final Map<EKey, CheckedInDep> checkedIns = new LinkedHashMap<EKey, CheckedInDep>();
    private final Map<EKey, SystemDep> systems = new LinkedHashMap<EKey, SystemDep>();
    private static final CollectionUtil.Filter<ElementDep> CONT = new CollectionUtil.Filter<ElementDep>(){

        @Override
        public boolean accept(ElementDep md) {
            return !md.subsumed;
        }
    };

    public ModuleDeps(ModuleC moduleC, Scope scope, ModuleDeps parent) {
        this.module = (Module)moduleC.element;
        this.scope = scope;
        this.parent = parent;
        this.exclude = moduleC.key.subkey.exclude;
        assert (scope.getParent() != null || parent == null);
        assert (scope.getParent() == null || parent != null);
    }

    public Iterable<ElementDep> getModuleDeps() {
        if (this.parent == null) {
            return this.elements.values();
        }
        return CollectionUtil.concat(this.parent.getModuleDeps(), this.elements.values());
    }

    public Iterable<CheckedInDep> getCheckedInDeps() {
        if (this.parent == null) {
            return this.checkedIns.values();
        }
        return CollectionUtil.concat(this.parent.getCheckedInDeps(), this.checkedIns.values());
    }

    public Iterable<SystemDep> getSystemDeps() {
        if (this.parent == null) {
            return this.systems.values();
        }
        return CollectionUtil.concat(this.parent.getSystemDeps(), this.systems.values());
    }

    public void addPart(ElementDep dep) {
        this.elements.put(dep.key, dep);
    }

    public void addCheckedIn(CheckedInDep dep) {
        this.checkedIns.put(dep.key, dep);
    }

    public void addSystem(SystemDep dep) {
        this.systems.put(dep.key, dep);
    }

    @Override
    public long lastModified() {
        long r = Long.MIN_VALUE;
        for (Module m : this.builders.values()) {
            try {
                r = Math.max(r, m.getDefault().lastModification(Scope.MAIN));
            }
            catch (EBuildException e) {
                throw new Error(e);
            }
        }
        for (ElementDep pd : this.elements.values()) {
            r = Math.max(r, pd.cElement.lastModification(Scope.MAIN));
        }
        for (CheckedInDep cid : this.checkedIns.values()) {
            r = Math.max(r, cid.getFile().lastModified());
        }
        return r;
    }

    public Map<EKey, AbstractDep> getAll() {
        HashMap<EKey, AbstractDep> r = new HashMap<EKey, AbstractDep>();
        r.putAll(this.elements);
        return r;
    }

    private void doDeepGather(Gatherer gatherer, CollectionUtil.Filter<ElementDep> filter) {
        for (SystemDep sd : this.getSystemDeps()) {
            gatherer.add(sd);
        }
        for (CheckedInDep cd : this.getCheckedInDeps()) {
            gatherer.add(cd);
        }
        for (ElementDep md : this.getModuleDeps()) {
            if (!filter.accept(md) || gatherer.deepExclude.match(md.key) || this.exclude.match(md.key)) continue;
            gatherer.add(md.getRelease());
            ModuleDeps mddeps = md.getDependencies();
            mddeps.doDeepGather(gatherer, CONT);
        }
    }

    public void startDeepGather(Gatherer gatherer, final boolean ignoreWorkspace, final boolean build) {
        this.doDeepGather(gatherer, new CollectionUtil.Filter<ElementDep>(){

            @Override
            public boolean accept(ElementDep md) {
                if (!build && md.subsumed) {
                    return false;
                }
                return !ignoreWorkspace || md.cElement.eclipse == null;
            }
        });
    }

    public Collection<ModuleRelease> asCollection() {
        return this.asCollection(Exclude.NONE);
    }

    public Collection<ModuleRelease> asCollection(Exclude excludes) {
        HashSet<ModuleRelease> r = new HashSet<ModuleRelease>(this.elements.size());
        for (ElementDep pd : this.getModuleDeps()) {
            if (pd.subsumed || excludes.match(pd.key)) continue;
            ModuleRelease dr = pd.getRelease();
            r.add(dr);
        }
        return r;
    }

    static abstract class AbstractDep {
        public final Scope scope;
        public final EKey key;

        AbstractDep(Scope scope, EKey key) {
            this.scope = scope;
            this.key = key;
        }
    }

    public class CheckedInDep
    extends AbstractDep {
        String type;

        public CheckedInDep(Scope scope, String name, String type) {
            super(scope, EKey.newUnversioned("checkedin", null, name));
            this.type = type;
        }

        File getFile() {
            File dir = new File(ModuleDeps.this.module.getProjectDirectory(), "checkedin");
            return new File(dir, this.key.name);
        }
    }

    public static class ElementDep
    extends AbstractDep {
        public final ModuleC cElement;
        public final boolean subsumed;

        public ElementDep(Scope scope, ModuleC cElement, boolean subsumed) {
            super(scope, ((Module)cElement.getPart()).key);
            this.cElement = cElement;
            this.subsumed = subsumed;
        }

        public ModuleDeps getDependencies() {
            return this.cElement.getDependencies(Scope.MAIN);
        }

        public ModuleRelease getRelease() {
            return (ModuleRelease)this.cElement.release;
        }

        public String toString() {
            return "subsumed=" + this.subsumed + " " + this.cElement;
        }
    }

    public static abstract class Gatherer {
        final Exclude deepExclude;

        public Gatherer(Exclude deepExclude) {
            this.deepExclude = deepExclude;
        }

        public abstract void add(ModuleRelease var1);

        public abstract void add(SystemDep var1);

        public abstract void add(CheckedInDep var1);
    }

    public static class GathererOfFiles
    extends Gatherer {
        public final String[] artifactTypes;
        public final Set<File> files = new LinkedHashSet<File>();

        public GathererOfFiles(String ... artifactTypes) {
            this(Exclude.NONE, artifactTypes);
        }

        public GathererOfFiles(Exclude deepExclude, String ... artifactTypes) {
            super(deepExclude);
            this.artifactTypes = artifactTypes;
        }

        public void add(ModuleRelease mr) {
            String[] stringArray = this.artifactTypes;
            int n = this.artifactTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String at = stringArray[n2];
                this.files.addAll(mr.getArtifacts(Scope.MAIN, at));
                ++n2;
            }
        }

        public void add(SystemDep dep) {
            String[] stringArray = this.artifactTypes;
            int n = this.artifactTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String at = stringArray[n2];
                File f = dep.getFile(at);
                if (f != null && f.exists()) {
                    this.files.add(f);
                }
                ++n2;
            }
        }

        public void add(CheckedInDep dep) {
            String[] stringArray = this.artifactTypes;
            int n = this.artifactTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String at = stringArray[n2];
                if (at.equals(dep.type)) {
                    this.files.add(dep.getFile());
                }
                ++n2;
            }
        }
    }

    public static class GathererOfReleases
    extends Gatherer {
        public final Set<ElementRelease> releases = new LinkedHashSet<ElementRelease>();

        public GathererOfReleases(Exclude deepExclude) {
            super(deepExclude);
        }

        public void add(ModuleRelease mr) {
            this.releases.add(mr);
        }

        public void add(SystemDep dep) {
        }

        public void add(CheckedInDep dep) {
        }
    }

    public class SystemDep
    extends AbstractDep {
        public SystemDep(Scope scope, String name, String tag) {
            super(scope, EKey.newTagged(null, "system", "system", name, tag));
        }

        public String name() {
            return this.key.name;
        }

        public File getFile(String artifactType) {
            String prop;
            if ("java_classes.jar".equals(artifactType) && "java.jdk.tools".equals(this.name()) && (prop = ModuleDeps.this.module.ebuild.getSettingProp("java.jdk.tools")) != null) {
                return new File(prop);
            }
            return null;
        }
    }
}

