/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IModuleBuildProject;
import ebuild.api.IModuleRelease;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.compat.IBuilderArgumentInCompat;
import ebuild.core.BuilderInstance;
import ebuild.core.EBuild;
import ebuild.core.ElementC;
import ebuild.core.Module;
import ebuild.core.ModuleDeps;
import ebuild.core.Project;
import ebuild.core.ProjectHelper;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.SubKey;
import ebuild.core.util.NameTemplate;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.xml.CmnXml;
import ebuild.xml.ModXml;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleProjectHelper
extends ProjectHelper {
    private final Module module;
    private ModXml.EbuildModuleBuild buildXml;
    private Boolean singleFolderLayout = null;
    private static final FilenameFilter FILTER_HIDDEN = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return !name.startsWith(".");
        }
    };

    ModuleProjectHelper(Module module) {
        super(module);
        this.module = module;
    }

    private boolean isSingleFolderLayout() {
        if (this.singleFolderLayout == null) {
            this.singleFolderLayout = new File(this.module.getProjectDirectory(), "src_main").exists();
        }
        return this.singleFolderLayout;
    }

    public Collection<String> listSourceArtifacts(Scope scope) {
        File dir = new File(this.module.getProjectDirectory(), "src/" + scope);
        return CollectionUtil.newSet(dir.list(FILTER_HIDDEN));
    }

    public File getSrcDirectory(Scope scope, String type) {
        return new File(this.module.getProjectDirectory(), this.getSrcFolder(false, scope, type));
    }

    public String getSrcFolder(boolean gen, Scope scope, String type) {
        return this.getSrcFolder(gen ? "gen" : "src", scope, type);
    }

    public String getSrcFolder(String kind, Scope scope, String type) {
        if (this.isSingleFolderLayout()) {
            return String.valueOf(kind) + "_" + scope;
        }
        return String.valueOf(kind) + "/" + scope + "/" + type;
    }

    private Module module() {
        return this.module;
    }

    @Override
    public ModXml.EbuildModuleBuild getBuildXml() throws EBuildException {
        if (this.buildXml == null) {
            this.buildXml = (ModXml.EbuildModuleBuild)this.module.expectMeta(MetaType.MODULE_BUILD);
        }
        return this.buildXml;
    }

    public List<? extends CmnXml.Builder> getBuildDependencies(SubKey subKey) throws EBuildException {
        return this.getBuildXml().builders;
    }

    public static File getCorespondingBuildDependency(IModuleBuildProject project, Scope scope, String artifactType, File jar) {
        File attempt;
        Collection lookup = project.getBuildDependencies(scope, artifactType);
        if (lookup.contains(attempt = FileUtil.canonicalFile(new File(jar.getParentFile(), "../" + artifactType)))) {
            return attempt;
        }
        String filename = FileUtil.removeSuffix(jar.getName());
        String suffix = FileUtil.fileSuffix(artifactType);
        if (suffix != null) {
            filename = String.valueOf(filename) + "." + suffix;
        }
        if (lookup.contains(attempt = FileUtil.canonicalFile(new File(jar.getParentFile(), "../" + artifactType + ".group/" + filename)))) {
            return attempt;
        }
        return null;
    }

    static void buildDependencyArtifacts(String artifactType, Collection<? extends IModuleRelease> deps, Scope scope, Collection<File> elements) {
        for (IModuleRelease iModuleRelease : deps) {
            ModuleProjectHelper.buildDependencyArtifacts(artifactType, iModuleRelease, scope, elements);
        }
    }

    static void buildDependencyArtifacts(String artifactType, IModuleRelease mod, Scope scope, Collection<File> elements) {
        Scope s = scope;
        while (s != null) {
            for (File f : mod.getArtifacts(s, artifactType)) {
                elements.add(f);
            }
            s = s.getParent();
        }
        ModuleProjectHelper.buildDependencyArtifacts(artifactType, mod.getDependencies(scope), scope, elements);
    }

    public static IPropertyMap configureProperties(ConfSet conf, BuilderInstance builderInstance) throws BuildPluginException, EBuildException {
        return EBuildUtil.configureProperties(builderInstance.getBuilder().newPropertyMap(), conf, builderInstance.propList);
    }

    public static Collection<File> getCheckedInArtifacts(ElementC cElement, Scope s, String type) {
        ModuleDeps mcdeps = (ModuleDeps)cElement.getDependencies(s);
        Iterable<ModuleDeps.CheckedInDep> deps = mcdeps.getCheckedInDeps();
        ArrayList<File> r = new ArrayList<File>();
        for (ModuleDeps.CheckedInDep d : deps) {
            if (type != null && !type.equals(d.type)) continue;
            r.add(d.getFile());
        }
        return r;
    }

    public String getJavaVersion() {
        return this.module().getJavaVersion();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractBuilderArgument
    implements IBuilderArgumentInCompat {
        final String filePrefix;
        final Project<Module> project;
        final ElementC<Module> cModule;
        final Module module;
        final String builderName;
        final IPropertyMap props;
        final Scope scope;

        AbstractBuilderArgument(Project<Module> project, Scope scope, BuilderInstance bi) throws BuildPluginException, EBuildException {
            this.filePrefix = ((IModuleBuildProject)project).filePrefix();
            this.project = project;
            this.cModule = project.cElement;
            this.module = (Module)this.cModule.element;
            this.builderName = bi.module.key.fullnameAndVersion();
            this.props = ModuleProjectHelper.configureProperties(this.cModule.getConfiguration(), bi);
            this.scope = scope;
        }

        @Override
        public abstract File getExportDirectory(String var1);

        public EBuild getEBuild() {
            return this.module.ebuild;
        }

        public ILogger getLogger() {
            return this.getEBuild().logger.newSubLogger("Builder/" + this.builderName);
        }

        public IPropertyMap getPropertyMap() {
            return this.props;
        }

        public Scope getScope() {
            return this.scope;
        }

        public List<File> getInputDirs(String artifactType) {
            File genDir;
            ArrayList<File> r = new ArrayList<File>(2);
            ModuleProjectHelper phelper = this.module.getProjectHelper();
            File srcDir = this.project.getProjectFile(phelper.getSrcFolder("src", this.scope, artifactType));
            if (srcDir.exists()) {
                r.add(srcDir);
            }
            if ((genDir = this.getGenDirectory(artifactType)) != null && genDir.exists()) {
                r.add(genDir);
            }
            return r;
        }

        @Override
        public Collection<File> getCheckedInArtifacts(String type) {
            return ModuleProjectHelper.getCheckedInArtifacts(this.cModule, this.scope, type);
        }

        @Override
        public String getArchiveName(String suffix) {
            try {
                NameTemplate nt = NameTemplate.parse(String.valueOf(this.module.key.fullname()) + "{-|confs}{-|version}" + "." + suffix);
                return nt.apply(EBuildUtil.newNameTemplateModel(this.module.key.version, this.cModule.getConfiguration()));
            }
            catch (EBuildException e) {
                throw new Error(e);
            }
        }

        @Override
        public FileFilter getFileFilter() {
            return EBuildUtil.getFileFilter(((Module)this.project.cElement.element).getRepository());
        }

        public File getOutputArtifact(String artifactType, boolean alwaysNamed) {
            File export = this.getExportDirectory(artifactType);
            if (alwaysNamed) {
                String suffix = FileUtil.fileSuffix(artifactType);
                artifactType = String.valueOf(artifactType) + ".group";
                String fileName = this.filePrefix;
                if (suffix == null) {
                    fileName = String.valueOf(fileName) + ".suffix";
                }
                return new File(export, fileName);
            }
            return export;
        }
    }
}

