/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IModuleRelease;
import ebuild.api.common.Scope;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.ElementC;
import ebuild.core.ElementRelease;
import ebuild.core.Module;
import ebuild.core.ModuleDeps;
import ebuild.core.impl.Exclude;
import ebuild.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleRelease
extends ElementRelease<Module>
implements IModuleRelease {
    public ModuleRelease(ElementC<Module> cElement, File dir) {
        super(cElement, dir);
    }

    public File getDirectory() {
        return this.getFile();
    }

    @Override
    public Collection<File> getArtifacts(Scope scope, String artifactType) {
        Collection<File> r = this.getArtifacts_(scope, artifactType);
        if (r.size() == 0) {
            if ("java_classes.jar".equals(artifactType)) {
                return this.getArtifacts_(scope, "java.classes.jar");
            }
            if ("java.classes.jar".equals(artifactType)) {
                return this.getArtifacts_(scope, "java_classes.jar");
            }
        }
        return r;
    }

    private Collection<File> getArtifacts_(Scope scope, String artifactType) {
        File export = new File(this.getFile(), String.valueOf(scope.getName()) + "/" + artifactType);
        File exportGroup = new File(this.getFile(), String.valueOf(scope.getName()) + "/" + artifactType + ".group");
        ArrayList<File> r = new ArrayList<File>();
        if (exportGroup.isDirectory()) {
            File[] files;
            File[] fileArray = files = exportGroup.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!"COPYRIGHT.txt".equals(f.getName())) {
                    r.add(f);
                }
                ++n2;
            }
            return r;
        }
        if (export.exists()) {
            r.add(export);
        }
        return r;
    }

    public void subsumeDependencies(Scope scope) throws EBuildException {
        Backtrace.startTop("subsume dependencies", this.cElement.key);
        try {
            ModuleDeps deps = (ModuleDeps)this.cElement.getDependencies(scope);
            for (ModuleDeps.ElementDep pd : deps.getModuleDeps()) {
                if (!pd.subsumed) continue;
                pd.getRelease().subsume(this, pd.scope);
            }
        }
        finally {
            Backtrace.endTop(this.cElement.key);
        }
    }

    public void subsume(ModuleRelease subsumer, Scope subsumerScope) throws EBuildException {
        Backtrace.start("subsume", this.cElement.key);
        try {
            try {
                FileUtil.mergeCopy(new File(this.getDirectory(), "main"), new File(subsumer.getDirectory(), subsumerScope.getName()));
            }
            catch (IOException e) {
                throw EBuildException.newError("Unable to subsume directory", e);
            }
            ModuleDeps deps = (ModuleDeps)this.cElement.getDependencies(Scope.MAIN);
            for (ModuleDeps.ElementDep pd : deps.getModuleDeps()) {
                if (pd.subsumed || deps.exclude.match(pd.key)) continue;
                ModuleRelease d = (ModuleRelease)pd.cElement.release;
                d.subsume(subsumer, subsumerScope);
            }
        }
        finally {
            Backtrace.end(this.cElement.key);
        }
    }

    @Override
    public Collection<IModuleRelease> getDependencies(Scope scope) {
        ModuleDeps deps = (ModuleDeps)this.cElement.getDependencies(scope);
        Collection<IModuleRelease> r = deps.asCollection();
        return r;
    }

    public String toString() {
        return "ModuleRelease: " + this.cElement;
    }

    public Collection<String> getClassPath(Exclude deepExclude) {
        ModuleDeps mcdeps = (ModuleDeps)this.cElement.getDependencies(Scope.MAIN);
        ModuleDeps.GathererOfFiles gatherer = new ModuleDeps.GathererOfFiles(deepExclude, "java_classes.jar");
        mcdeps.startDeepGather(gatherer, false, false);
        gatherer.add((ModuleRelease)this.cElement.release);
        LinkedHashSet<String> r = new LinkedHashSet<String>(gatherer.files.size());
        for (File f : gatherer.files) {
            r.add(f.getAbsolutePath());
        }
        return r;
    }
}

