/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IEBuild;
import ebuild.api.IGenConfArgument;
import ebuild.api.IModuleBuildProject;
import ebuild.api.IModuleRelease;
import ebuild.api.IModuleWorkspaceProject;
import ebuild.api.common.IElementKey;
import ebuild.api.common.Scope;
import ebuild.api.eclipse.IEclipseProject;
import ebuild.api.plugin.IPropertyMap;
import ebuild.compat.IModuleBuildProjectInCompat;
import ebuild.core.BuilderChain;
import ebuild.core.BuilderInstance;
import ebuild.core.EBuild;
import ebuild.core.ElementC;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleDeps;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.WorkspaceProject;
import ebuild.core.conf.ConfSet;
import ebuild.eclipse.EclipseProject;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleWorkspaceProject
extends WorkspaceProject<Module>
implements IModuleWorkspaceProject,
IModuleBuildProjectInCompat {
    public final Module module;
    public final ModuleC moduleC;
    private final ModuleProjectHelper helper;
    private final EclipseProject eclipseProject;
    private static final Scope[] CALL_ORDER = new Scope[]{Scope.MAIN, Scope.TEST, Scope.POKE};

    public ModuleWorkspaceProject(ElementC<Module> cElement) {
        super((ElementC)cElement);
        this.moduleC = (ModuleC)cElement;
        this.module = (Module)this.moduleC.element;
        this.helper = this.module.getProjectHelper();
        this.eclipseProject = new EclipseProject(this);
    }

    @Override
    public ModuleC getCPart() {
        return (ModuleC)super.getCPart();
    }

    @Override
    public File getSrcDirectory(Scope scope, String type) {
        return this.helper.getSrcDirectory(scope, type);
    }

    public String getArtifactPath(String kind, Scope scope, String type) {
        return this.helper.getSrcFolder(kind, scope, type);
    }

    @Override
    public Collection<File> getCheckedInArtifacts(Scope s, String type) {
        return ModuleProjectHelper.getCheckedInArtifacts(this.cElement, s, type);
    }

    public String getJavaVersion() {
        return this.helper.getJavaVersion();
    }

    public IElementKey getKey() {
        return this.module.key;
    }

    public Collection<File> getBuildDependencies(Scope scope, String artifactType) {
        ModuleDeps.GathererOfFiles gatherer = new ModuleDeps.GathererOfFiles(artifactType);
        ModuleDeps deps = (ModuleDeps)this.cElement.getDependencies(scope);
        deps.startDeepGather(gatherer, true, true);
        return gatherer.files;
    }

    public File getCorespondingBuildDependency(Scope scope, String artifactType, File artifact) {
        return ModuleProjectHelper.getCorespondingBuildDependency(this, scope, artifactType, artifact);
    }

    private String getSrcPath(boolean gen, Scope scope, String type) {
        return this.helper.getSrcFolder(gen, scope, type);
    }

    @Override
    public IModuleRelease getModuleRelease() {
        throw new UnsupportedOperationException();
    }

    public void addIgnores(String ... patterns) {
        this.module.addIgnores(patterns);
    }

    public IEclipseProject asEclipseProject() {
        return this.eclipseProject;
    }

    public String filePrefix() {
        return null;
    }

    @Override
    public Collection<IModuleRelease> getReleasedDependencies(Scope scope) {
        LinkedHashSet<IModuleRelease> r = new LinkedHashSet<IModuleRelease>();
        for (ModuleDeps.ElementDep pd : this.moduleC.getDependencies(scope).getModuleDeps()) {
            if (pd.cElement.eclipse != null || pd.subsumed) continue;
            r.add((IModuleRelease)((Object)pd.cElement.release));
        }
        return r;
    }

    public Collection<IModuleWorkspaceProject> getWorkspaceDependencies(Scope scope) {
        LinkedHashSet<IModuleWorkspaceProject> r = new LinkedHashSet<IModuleWorkspaceProject>();
        for (ModuleDeps.ElementDep pd : this.moduleC.getDependencies(scope).getModuleDeps()) {
            if (pd.cElement.eclipse == null) continue;
            r.add((IModuleWorkspaceProject)pd.cElement.eclipse);
        }
        return r;
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.eclipseProject.init();
        final EBuild ebuild = this.module.ebuild;
        BuilderChain chain = this.getCPart().configureAndParameterizeBuilderChain();
        for (BuilderInstance b : chain.getBuilders()) {
            if (b.hasEclipseNature()) {
                final IPropertyMap props = ModuleProjectHelper.configureProperties((ConfSet)this.getConfiguration(), b);
                b.generateEclipseProjectSettings(new IGenConfArgument(){

                    public IModuleWorkspaceProject getModuleWorkspaceProject() {
                        return ModuleWorkspaceProject.this;
                    }

                    public IEBuild getEBuild() {
                        return ebuild;
                    }

                    public IPropertyMap getPropertyMap() {
                        return props;
                    }
                });
                continue;
            }
            Scope[] scopeArray = CALL_ORDER;
            int n = CALL_ORDER.length;
            int n2 = 0;
            while (n2 < n) {
                Scope s = scopeArray[n2];
                ModuleProjectHelper.AbstractBuilderArgument arg = new ModuleProjectHelper.AbstractBuilderArgument(this, s, b){

                    public boolean isBuild() {
                        return false;
                    }

                    public boolean isFirstCall() {
                        return this.scope == CALL_ORDER[0];
                    }

                    public File getExportDirectory(String artifactType) {
                        return this.getGenDirectory(artifactType);
                    }

                    public File getGenDirectory(String artifactType) {
                        return new File(this.module.getProjectDirectory(), ModuleWorkspaceProject.this.getSrcPath(true, this.getScope(), artifactType));
                    }

                    public File getIntermediateDir(String uniquePath) {
                        throw new UnsupportedOperationException();
                    }

                    public IModuleBuildProject getModuleBuildProject() {
                        return ModuleWorkspaceProject.this;
                    }
                };
                b.build(arg);
                ++n2;
            }
        }
        this.eclipseProject.commit();
    }

    @Override
    public void unsetup() throws Exception {
        super.unsetup();
        FileUtil.deleteDir(this.module.getFile("gen"));
        this.module.getFile(".classpath").delete();
    }

    public String readProjectFile(String path) throws IOException {
        return IOUtil.fileToString(this.getProjectFile(path));
    }

    public void writeProjectFile(String path, String text) throws IOException {
        IOUtil.stringToFile(text, this.getProjectFile(path));
    }
}

