/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ElementNature;
import ebuild.core.ProductC;
import ebuild.core.ProductProjectHelper;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.impl.SubKey;
import ebuild.core.util.NameTemplate;
import ebuild.xml.PrdXml;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Product
extends Element<PrdXml.EbuildProduct> {
    private Map<String, NameTemplate> artifacts;
    private String defaultArtifact;

    public Product(EBuildMode mode, File directory, EBuild ebuild, EKey key, ElementNature nature) throws EBuildException {
        super(mode, directory, ebuild, key, nature);
    }

    @Override
    public void initDeclaration() throws EBuildException {
        this.declaration = (PrdXml.EbuildProduct)this.expectMeta(MetaType.PRODUCT);
        LinkedHashMap<String, NameTemplate> artifacts = new LinkedHashMap<String, NameTemplate>();
        for (PrdXml.Artifact a : ((PrdXml.EbuildProduct)this.getDeclaration()).artifacts) {
            artifacts.put(a.name, this.getNameTemplate(a));
        }
        if (artifacts.size() == 0) {
            throw EBuildException.newProblem("Expected at least one <artifact/> in component declaration.");
        }
        this.defaultArtifact = (String)artifacts.keySet().iterator().next();
        this.artifacts = artifacts;
    }

    @Override
    public ElementC newCElement(SubKey subKey, ConfSet confSelected) {
        return new ProductC(this, this.resolveKey(subKey), confSelected);
    }

    @Override
    public ProductProjectHelper newProjectHelper() throws EBuildException {
        return new ProductProjectHelper(this);
    }

    @Override
    public ProductProjectHelper getProjectHelper() {
        return (ProductProjectHelper)super.getProjectHelper();
    }

    @Override
    public ElementType getType() {
        return ElementType.product;
    }

    private SubKey resolveKey(SubKey subKey) {
        if (subKey.artifact == null) {
            subKey = new SubKey(subKey.conf, this.defaultArtifact);
        }
        return subKey;
    }

    public Map<String, ModuleSelectionIncludes> getModuleSelectionXml(SubKey subKey) throws EBuildException {
        ConfSet conf = subKey.conf;
        final HashMap<String, ModuleSelectionIncludes> r = new HashMap<String, ModuleSelectionIncludes>();
        ProductProjectHelper productProjectHelper = this.getProjectHelper();
        productProjectHelper.getClass();
        new ProductProjectHelper.AssemblyVisitor(productProjectHelper, conf){

            public Object visitModuleSelection(String path, PrdXml.ModuleSelection moduleSelection) {
                String confMapping = moduleSelection.confMapping;
                List<PrdXml.Include> l = moduleSelection.includes;
                PrdXml.OurModule ours = moduleSelection.ourModule;
                if (ours != null) {
                    PrdXml.Include inc = new PrdXml.Include();
                    inc.source = "local";
                    inc.org = Product.this.key.org;
                    inc.name = Product.this.key.name;
                    inc.conf = ours.conf;
                    inc.confMapping = ours.confMapping;
                    inc.revision = Product.this.key.version.getRevision();
                    inc.branch = Product.this.key.version.getBranch();
                    inc.tag = Product.this.key.version.getTag();
                    inc.dependencies = ours.dependencies;
                    ArrayList<PrdXml.Include> l2 = new ArrayList<PrdXml.Include>(l.size() + 1);
                    l2.addAll(l);
                    l2.add(inc);
                    l = l2;
                }
                ModuleSelectionIncludes msi = new ModuleSelectionIncludes(moduleSelection.artifact, confMapping, l);
                r.put(path, msi);
                return null;
            }
        }.go(subKey.artifact);
        return r;
    }

    public Map<String, PrdXml.Product> getSelectedComponentsXml(SubKey subKey) throws EBuildException {
        final HashMap<String, PrdXml.Product> r = new HashMap<String, PrdXml.Product>();
        ProductProjectHelper productProjectHelper = this.getProjectHelper();
        productProjectHelper.getClass();
        new ProductProjectHelper.AssemblyVisitor(productProjectHelper, subKey.conf){

            Object visitProduct(String path, PrdXml.Product component) {
                r.put(path, component);
                return null;
            }
        }.go(subKey.artifact);
        return r;
    }

    public String releaseSourceFileName() {
        return this.key.fullnameAndVersion();
    }

    public String expectArtifactName(String artifact, ConfSet confs) {
        NameTemplate nt;
        if (artifact == null) {
            artifact = this.defaultArtifact;
        }
        if ((nt = this.artifacts.get(artifact)) == null) {
            throw new Error("No such artifact: " + artifact);
        }
        return nt.apply(EBuildUtil.newNameTemplateModel(this.key.version, confs));
    }

    private NameTemplate getNameTemplate(PrdXml.Artifact a) throws EBuildException {
        String pattern = a.pattern;
        if (pattern == null) {
            String prefix = a.prefix;
            if (prefix == null) {
                prefix = a.name;
            }
            pattern = String.valueOf(prefix) + "{-|confs}{-|version}";
            String suffix = a.suffix;
            if (suffix != null) {
                pattern = String.valueOf(pattern) + suffix;
            }
        }
        return NameTemplate.parse(pattern);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ModuleSelectionIncludes {
        final String artifact;
        final String groupMapping;
        final List<PrdXml.Include> includes;

        ModuleSelectionIncludes(String artifact, String groupMapping, List<PrdXml.Include> includes) {
            this.artifact = artifact;
            this.groupMapping = groupMapping;
            this.includes = includes;
        }
    }
}

