/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildRunner;
import ebuild.core.ElementC;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.Product;
import ebuild.core.ProductC;
import ebuild.core.ProductDeps;
import ebuild.core.ProductProjectHelper;
import ebuild.core.conf.ConfMapping;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.ArtifactKey;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.SubKey;
import ebuild.core.impl.TaskSet;
import ebuild.util.tuple.Pair;
import ebuild.xml.CmnXml;
import ebuild.xml.PrdXml;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductBuildPlan
extends BuildPlan {
    final Product component;
    final EBuildContext context;
    private final ProductC productC;
    private final Map<String, BuildPlan> subPlans = new LinkedHashMap<String, BuildPlan>();

    public ProductBuildPlan(EBuildRunner runner, ElementC<Product> elementC) {
        super(runner, elementC.key);
        this.component = (Product)elementC.element;
        if (!this.component.isSource()) {
            throw new Error("Non-source components not currently supported");
        }
        this.context = this.component.getProjectHelper().context;
        this.productC = (ProductC)elementC;
    }

    public ConfSet getConf() {
        return this.productC.getConfiguration();
    }

    public ConfSet getArtifact() {
        return this.productC.getConfiguration();
    }

    @Override
    public ArtifactKey getKey() {
        return (ArtifactKey)super.getKey();
    }

    public ElementC expectLoneCPart() {
        return this.productC;
    }

    @Override
    protected void resolveAndConfigure_(TaskSet tasks) throws EBuildException {
        if (!((Product)this.productC.element).isWorkspace()) {
            tasks = tasks.withoutIDE();
        }
        this.report.startResolveMain();
        this.resolveDependencies(tasks);
        this.report.endResolveMain();
        for (BuildPlan bp : this.subPlans.values()) {
            bp.resolveAndConfigure(tasks);
        }
        ProductDeps deps = this.newCDependencies();
        this.productC.setDependencies(deps);
    }

    void resolveDependencies(TaskSet tasks) throws EBuildException {
        Backtrace.start("resolve dependencies", this.context);
        try {
            ProductProjectHelper phelper = this.component.getProjectHelper();
            this.resolveContext(phelper);
            Map<String, Product.ModuleSelectionIncludes> moduleSelections = this.component.getModuleSelectionXml(this.productC.getSubKey());
            for (String k : moduleSelections.keySet()) {
                Product.ModuleSelectionIncludes includes = moduleSelections.get(k);
                Pair<ArtifactKey, String> key = new Pair<ArtifactKey, String>(this.getKey(), k);
                ConfMapping groupMapping = EBuildUtil.parseMapping(includes.groupMapping);
                ConfSet groupConfs = groupMapping.evaluate(this.getConf());
                if (this.runner.buildPlans.containsKey(key)) {
                    throw new Error("Unexpected error, build plan exists already: " + key);
                }
                ModuleBuildPlan mbp = new ModuleBuildPlan(this.runner, key, includes.artifact);
                this.report.addPlan(mbp);
                this.subPlans.put(k, mbp);
                mbp.setGroupConfs(groupConfs);
                for (PrdXml.Include d : includes.includes) {
                    String source;
                    if (!EBuildUtil.evaluateExpr(d.conf, this.getConf()) || "system".equals(source = d.source) || "checkedin".equals(source)) continue;
                    EKey dkey = this.context.newModuleKey(d);
                    Backtrace.start("resolve dependency", dkey);
                    try {
                        Module dmodule = (Module)this.resolveElement(this.context, source, dkey);
                        ConfSet confs = EBuildUtil.evaluateMapping(d.confMapping, this.getConf());
                        Exclude exclude = d.dependencies ? Exclude.NONE : Exclude.ALL;
                        mbp.addModule(dmodule, confs, exclude);
                    }
                    finally {
                        Backtrace.end(dkey);
                    }
                }
            }
            Map<String, PrdXml.Product> components = this.component.getSelectedComponentsXml(this.productC.getSubKey());
            for (String k : components.keySet()) {
                CmnXml.SelectAndMap d = components.get(k);
                EKey dkey = this.context.newElementKey(ElementType.product, d);
                Product delement = (Product)this.resolveElement(this.context, d.source, dkey);
                ConfMapping mapping = EBuildUtil.parseMapping(d.confMapping, ConfMapping.EMPTY);
                ConfSet dconf = mapping.evaluate(this.getConf());
                SubKey subKey = new SubKey(dconf, d.artifact);
                ArtifactKey cekey = new ArtifactKey(delement.key, subKey);
                BuildPlan subPlan = this.runner.buildPlans.get(cekey);
                if (subPlan == null) {
                    subPlan = new ProductBuildPlan(this.runner, delement.getCPart(subKey));
                    this.report.addPlan(subPlan);
                    this.report.configure(delement.key, dconf);
                }
                this.subPlans.put(k, subPlan);
            }
        }
        finally {
            Backtrace.end(this.context);
        }
    }

    ProductDeps newCDependencies() {
        ProductDeps r = new ProductDeps();
        for (String k : this.subPlans.keySet()) {
            BuildPlan bp = this.subPlans.get(k);
            if (bp instanceof ModuleBuildPlan) {
                ModuleBuildPlan mbp = (ModuleBuildPlan)bp;
                Collection<ElementC> mods = mbp.getPrimaryModules();
                r.addModuleSelection(new ProductDeps.ModuleSelectionDep(k, mods));
                continue;
            }
            ProductBuildPlan cbp = (ProductBuildPlan)bp;
            r.addComponent(new ProductDeps.ComponentDep(k, cbp.productC));
        }
        return r;
    }

    @Override
    protected void resolveBuilders(TaskSet tasks) throws EBuildException {
        this.resolveBuildersForPart(this.productC);
    }

    @Override
    protected void buildActionList_(ActionQueue queue, TaskSet tasks) throws Exception {
        if (!((Product)this.productC.element).isWorkspace()) {
            tasks = tasks.withoutIDE();
        }
        for (BuildPlan subPlan : this.subPlans.values()) {
            subPlan.buildActionList(queue, tasks);
        }
        this.buildActionListForPart(queue, (ElementC)this.productC, tasks);
    }
}

