/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IAssemblerArgument;
import ebuild.api.IEBuild;
import ebuild.api.IInputMap;
import ebuild.api.common.IElementKey;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.base.EBuildException;
import ebuild.core.BuildProject;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.ElementC;
import ebuild.core.Module;
import ebuild.core.Product;
import ebuild.core.ProductC;
import ebuild.core.ProductDeps;
import ebuild.core.ProductProjectHelper;
import ebuild.core.ProductRelease;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.Input;
import ebuild.core.impl.InputMap;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.xml.PrdXml;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductBuildProject
extends BuildProject<Product> {
    private final EBuild ebuild;
    private final Product component;
    private final ProductC cElement;

    public ProductBuildProject(ProductC cElement) {
        super((ElementC)cElement);
        this.cElement = cElement;
        this.component = (Product)cElement.element;
        this.ebuild = this.component.ebuild;
    }

    @Override
    public long releaseLastModified() {
        return FileUtil.deepLastModified(this.cElement.releaseFile());
    }

    @Override
    public void buildRun() throws Exception {
        ArtifactGenerator releaseGenerator = this.construct();
        Collection<File> artifacts = releaseGenerator.assemble(this.ebuild);
        if (artifacts.size() != 1) {
            throw EBuildException.newProblem("Expected single artifact from release, got " + artifacts.size());
        }
        File a = artifacts.iterator().next();
        FileUtil.copy(a, this.cElement.release.getFile());
    }

    private ArtifactGenerator construct() throws EBuildException, BuildPluginException {
        ProductProjectHelper phelper = this.component.getProjectHelper();
        final EBuildContext context = phelper.context;
        ProductProjectHelper productProjectHelper = phelper;
        productProjectHelper.getClass();
        return (ArtifactGenerator)new ProductProjectHelper.AssemblyVisitor<ArtifactGenerator>(productProjectHelper, this.getConfiguration()){

            @Override
            ArtifactGenerator visitGroup(String path, PrdXml.AssemblyGroup group, List<ArtifactGenerator> members) {
                if (members.size() == 1) {
                    return members.get(0);
                }
                return new AssemblyGroup(path, members);
            }

            @Override
            ArtifactGenerator visitAssembler(String path, PrdXml.Assembler assemblerXml, Map<String, ArtifactGenerator> inputs) throws EBuildException {
                EKey assemblerKey = context.newModuleKey(assemblerXml);
                Module assemblerModule = (Module)((ProductBuildProject)ProductBuildProject.this).cElement.getDependencies().builders.get(assemblerKey);
                EKey resolvedKey = assemblerModule.key;
                AbstractAssembler assembler = ProductBuildProject.this.ebuild.expectAssembler(resolvedKey);
                IPropertyMap properties = EBuildUtil.configureProperties(assembler.newPropertyMap(), ProductBuildProject.this.getConfiguration(), assemblerXml.propsList);
                return new AssemblerInstance(path, resolvedKey, assembler, inputs, properties);
            }

            @Override
            ArtifactGenerator visitProduct(String path, PrdXml.Product component) {
                ProductDeps deps = ProductBuildProject.this.cElement.getDependencies();
                ProductDeps.ComponentDep dep = deps.components.get(path);
                return new ComponentSelect(path, (ProductRelease)dep.cElement.release);
            }

            @Override
            ArtifactGenerator visitModuleSelection(String path, PrdXml.ModuleSelection ms) throws EBuildException {
                Exclude excludes = Exclude.newExclude(ms.excludes);
                ProductDeps deps = ProductBuildProject.this.cElement.getDependencies();
                ProductDeps.ModuleSelectionDep dep = deps.moduleSelections.get(path);
                String[] artifactTypes = ms.artifact.split(",");
                Collection<File> artifacts = dep.getArtifacts(excludes, artifactTypes);
                return new ModuleSelectionInstance(path, artifacts);
            }
        }.go(this.cElement.getArtifact());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class ArtifactGenerator {
        private final String path;
        private final File outputDir;
        private Collection<File> artifacts = null;

        public ArtifactGenerator(String path) {
            this.path = path;
            this.outputDir = new File(ProductBuildProject.this.getIntermediateDirectory(), path);
        }

        final Collection<File> assemble(EBuild ebuild) throws Exception {
            if (this.artifacts == null) {
                this.artifacts = this.assemble_(ebuild);
            }
            return this.artifacts;
        }

        abstract Collection<File> assemble_(EBuild var1) throws Exception;

        public File useOutputDir() {
            this.outputDir.mkdirs();
            return this.outputDir;
        }

        public String toString() {
            return String.valueOf(this.path) + " - " + this.getClass().getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AssemblerInstance
    extends ArtifactGenerator {
        final EKey resolvedKey;
        final AbstractAssembler assembler;
        final Map<String, ArtifactGenerator> inputGenerators;
        final IPropertyMap properties;

        public AssemblerInstance(String path, EKey resolvedKey, AbstractAssembler assembler, Map<String, ArtifactGenerator> inputGenerators, IPropertyMap properties) throws EBuildException {
            super(path);
            this.resolvedKey = resolvedKey;
            this.assembler = assembler;
            this.inputGenerators = inputGenerators;
            this.properties = properties;
        }

        @Override
        public Collection<File> assemble_(final EBuild ebuild) throws Exception {
            final InputMap inputs = new InputMap();
            for (String key : this.inputGenerators.keySet()) {
                ArtifactGenerator apc = this.inputGenerators.get(key);
                Collection<File> a = apc.assemble(ebuild);
                inputs.put(key, new Input(key, a));
            }
            IAssemblerArgument arg = new IAssemblerArgument(){

                public IEBuild getEBuild() {
                    return ebuild;
                }

                public ILogger getLogger() {
                    return ebuild.logger.newSubLogger("Assembler/" + AssemblerInstance.this.resolvedKey.fullnameAndVersion());
                }

                public IPropertyMap getPropertyMap() {
                    return AssemblerInstance.this.properties;
                }

                public IInputMap getInputMap() {
                    return inputs;
                }

                public File getOutputDirectory() {
                    return AssemblerInstance.this.useOutputDir();
                }

                public Date getLastCommitDate() {
                    return ProductBuildProject.this.component.getLastCommitDate();
                }

                public IElementKey getComponentKey() {
                    return ((ProductBuildProject)((AssemblerInstance)AssemblerInstance.this).ProductBuildProject.this).component.key;
                }

                public String getReleaseFileName() {
                    return ProductBuildProject.this.cElement.releaseFileName();
                }
            };
            IPropertyMap props = arg.getPropertyMap();
            ILogger logger = arg.getLogger();
            logger.prime();
            logger.setProvisionalHeading("Properties");
            for (String k : props.listKeys()) {
                Object v = props.get(k);
                logger.log("    " + k + ": " + v);
            }
            return this.assembler.assemble(arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AssemblyGroup
    extends ArtifactGenerator {
        final List<ArtifactGenerator> generators;

        AssemblyGroup(String path, List<ArtifactGenerator> generators) {
            super(path);
            this.generators = generators;
        }

        @Override
        public Collection<File> assemble_(EBuild ebuild) throws Exception {
            ArrayList<File> r = new ArrayList<File>(this.generators.size());
            for (ArtifactGenerator g : this.generators) {
                r.addAll(g.assemble(ebuild));
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComponentSelect
    extends ArtifactGenerator {
        final ProductRelease release;

        ComponentSelect(String path, ProductRelease release) {
            super(path);
            this.release = release;
        }

        @Override
        Collection<File> assemble_(EBuild ebuild) throws Exception {
            return CollectionUtil.singletonList(this.release.getFile());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ModuleSelectionInstance
    extends ArtifactGenerator {
        final Collection<File> artifacts;

        public ModuleSelectionInstance(String path, Collection<File> artifacts) {
            super(path);
            this.artifacts = artifacts;
        }

        @Override
        Collection<File> assemble_(EBuild ebuild) {
            return this.artifacts;
        }
    }
}

