/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.EBuildException;
import ebuild.core.ElementC;
import ebuild.core.ElementDeps;
import ebuild.core.Module;
import ebuild.core.ModuleDeps;
import ebuild.core.ModuleRelease;
import ebuild.core.Product;
import ebuild.core.impl.Exclude;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ProductDeps
extends ElementDeps {
    public final Map<String, ComponentDep> components = new HashMap<String, ComponentDep>();
    public final Map<String, ModuleSelectionDep> moduleSelections = new HashMap<String, ModuleSelectionDep>();

    public void addComponent(ComponentDep dep) {
        this.components.put(dep.key, dep);
    }

    public void addModuleSelection(ModuleSelectionDep dep) {
        this.moduleSelections.put(dep.key, dep);
    }

    public long lastModified() {
        long r = Long.MIN_VALUE;
        for (Module m : this.builders.values()) {
            try {
                r = Math.max(r, m.getDefault().lastModification(Scope.MAIN));
            }
            catch (EBuildException e) {
                throw new Error(e);
            }
        }
        for (ComponentDep cd : this.components.values()) {
            r = Math.max(r, cd.cElement.lastModification(Scope.MAIN));
        }
        for (ModuleSelectionDep msd : this.moduleSelections.values()) {
            for (ElementC cp : msd.modules) {
                r = Math.max(r, cp.lastModification(Scope.MAIN));
            }
        }
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComponentDep {
        final String key;
        final ElementC<Product> cElement;

        public ComponentDep(String key, ElementC<Product> cElement) {
            this.key = key;
            this.cElement = cElement;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModuleSelectionDep {
        final String key;
        final Collection<ElementC> modules;

        public ModuleSelectionDep(String key, Collection<ElementC> modules) {
            this.key = key;
            this.modules = modules;
        }

        public Collection<File> getArtifacts(Exclude deepExclude, String[] artifactTypes) {
            ModuleDeps.GathererOfFiles gatherer = new ModuleDeps.GathererOfFiles(deepExclude, artifactTypes);
            for (ElementC cElement : this.modules) {
                ModuleDeps mcdeps = (ModuleDeps)cElement.getDependencies(Scope.MAIN);
                mcdeps.startDeepGather(gatherer, false, false);
                ModuleRelease mr = (ModuleRelease)cElement.release;
                gatherer.add(mr);
            }
            return gatherer.files;
        }
    }
}

