/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.core.Product;
import ebuild.core.ProjectHelper;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.SubKey;
import ebuild.xml.CmnXml;
import ebuild.xml.PrdXml;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductProjectHelper
extends ProjectHelper {
    final Product component;
    private PrdXml.EbuildProductAssembly buildXml;

    ProductProjectHelper(Product component) {
        super(component);
        this.component = component;
    }

    @Override
    public PrdXml.EbuildProductAssembly getBuildXml() throws EBuildException {
        if (this.buildXml == null) {
            this.buildXml = (PrdXml.EbuildProductAssembly)this.component.expectMeta(MetaType.PRODUCT_ASSEMBLY);
        }
        return this.buildXml;
    }

    public List<PrdXml.Target> getTargetsXml() throws EBuildException {
        return this.getBuildXml().targets;
    }

    @Override
    public Iterable<? extends CmnXml.SelectWithSource> getBuildDependencies(SubKey subKey) throws EBuildException {
        final HashSet r = new HashSet(10);
        new AssemblyVisitor(subKey.conf){

            public Object visitAssembler(String path, PrdXml.Assembler assembler, Map inputs) {
                r.add(assembler);
                return null;
            }
        }.go(subKey.artifact);
        return r;
    }

    PrdXml.Target expectTarget(String target) throws EBuildException {
        for (PrdXml.Target t : this.getTargetsXml()) {
            if (!target.equals(t.name)) continue;
            return t;
        }
        throw EBuildException.newProblem("Bad reference, no <target> for ref: " + target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AssemblyVisitor<R> {
        final ConfSet configuration;
        Map<String, R> norecurse = new HashMap<String, R>();

        AssemblyVisitor() {
            this(null);
        }

        AssemblyVisitor(ConfSet configuration) {
            this.configuration = configuration;
        }

        R go(String target) throws EBuildException {
            return this.recurseNamed(target);
        }

        R visitProduct(String path, PrdXml.Product component) throws EBuildException {
            return null;
        }

        R visitModuleSelection(String path, PrdXml.ModuleSelection moduleSelection) throws EBuildException {
            return null;
        }

        R visitAssembler(String path, PrdXml.Assembler assembler, Map<String, R> inputs) throws EBuildException {
            return null;
        }

        R visitGroup(String path, PrdXml.AssemblyGroup group, List<R> members) throws EBuildException {
            return null;
        }

        R recurseNamed(String name) throws EBuildException {
            if (this.norecurse.containsKey(name)) {
                return this.norecurse.get(name);
            }
            R r = this.recurseGroup(name, ProductProjectHelper.this.expectTarget(name));
            this.norecurse.put(name, r);
            return r;
        }

        private String subpath(int size, String path, int i) {
            if (size == 1) {
                return path;
            }
            return String.valueOf(path) + "_" + i;
        }

        R recurseGroup(String path, PrdXml.AssemblyGroup group) throws EBuildException {
            return this.visitGroup(path, group, this.recurseGroupMembers(path, group));
        }

        List<R> recurseGroupMembers(String path, PrdXml.AssemblyGroup group) throws EBuildException {
            String path2;
            int size = group.count();
            ArrayList<R> r = new ArrayList<R>(size);
            int i = 0;
            if (group.ref != null) {
                ++i;
                r.add(this.recurseNamed(group.ref));
            }
            for (PrdXml.Ref ref : group.refs) {
                ++i;
                r.add(this.recurseNamed(ref.name));
            }
            for (PrdXml.Assembler ass : group.assemblers) {
                path2 = this.subpath(size, path, i++);
                r.add(this.visitAssembler(path2, ass, this.recurseInputs(path2, ass.inputList)));
            }
            for (PrdXml.Product c : group.products) {
                if (EBuildUtil.evaluateExpr(c.conf, this.configuration)) {
                    r.add(this.visitProduct(this.subpath(size, path, i), c));
                }
                ++i;
            }
            for (PrdXml.ModuleSelection ms : group.moduleSelections) {
                r.add(this.visitModuleSelection(this.subpath(size, path, i++), ms));
            }
            for (PrdXml.If if_ : group.ifs) {
                path2 = this.subpath(size, path, i++);
                r.add(this.recurseIf(path2, if_));
            }
            return r;
        }

        Map<String, R> recurseInputs(String path, List<PrdXml.Input> inputs) throws EBuildException {
            LinkedHashMap<String, R> r = new LinkedHashMap<String, R>(inputs.size());
            for (PrdXml.Input i : inputs) {
                String name;
                String path2 = i.appendToPath(path);
                R a = this.recurseGroup(path2, i);
                String string = name = i.name == null ? "anonymous" : i.name;
                if (r.containsKey(name)) {
                    throw EBuildException.newProblem("Multiple inputs must have distinct names: " + name);
                }
                r.put(i.name, a);
            }
            return r;
        }

        R recurseIf(String path, PrdXml.If if_) throws EBuildException {
            if (EBuildUtil.evaluateExpr(if_.cond, this.configuration)) {
                return this.recurseGroup(path, if_.then);
            }
            return this.recurseGroup(path, if_.else_);
        }
    }
}

